<?php

/**
 *
 * @link              https://www.arwebcrafts.com/
 * @since             1.0.0
 * @package           Woocommerce_Bulk_Edit
 *
 * @wordpress-plugin
 * Plugin Name:       WooCommerce Bulk Edit
 * Plugin URI:        https://www.arwebcrafts.com/downloads/woocommerce-bulk-edit
 * Description:       WooCommerce bulk edit provides easy user interface for adding and editing products on one screen.
 * Version:           1.0.0
 * Author:            ARwebcrafts
 * Author URI:        https://www.arwebcrafts.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       woocommerce-bulk-edit
 * Domain Path:       /languages
 */

define( 'WOOCOMMERCE_BULK_EDIT_FILE', __FILE__ );
define( 'WOOCOMMERCE_BULK_EDIT_URL', plugin_dir_url( __FILE__ )) ;
define( 'WOOCOMMERCE_BULK_EDIT_PLUGIN_NAME', 'WooCommerce Bulk Edit' );

use WooCommerceBulkEditor\Admin\Admin;
use WooCommerceBulkEditor\Admin\Ajax;
use WooCommerceBulkEditor\Admin\Editor;
use WooCommerceBulkEditor\Admin\History;
use WooCommerceBulkEditor\Includes\Data;
use WooCommerceBulkEditor\Includes\Enqueue;

defined( 'ABSPATH' ) || exit;

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	
if ( is_file( plugin_dir_path( __FILE__ ) . 'autoload.php' ) ) {
	require_once plugin_dir_path( __FILE__ ) . 'autoload.php';
	require_once plugin_dir_path( __FILE__ ) . 'admin/license/class-woocommerce-bulk-edit-license.php';
	require_once plugin_dir_path( __FILE__ ) . 'admin/license/class-woocommerce-bulk-edit-plugin-updater.php';
}

if( ! class_exists( 'WooCommerce_Bulk_Edit' ) ){

	class WooCommerce_Bulk_Edit {
		public $plugin_name = 'WooCommerce Bulk Edit';

		public $version = '1.0.0';

		public $conditional = '';

		protected static $instance = null;

		public function __construct() {
			
			$this->woocommerce_bulk_edit_check_conditions();

			if( empty( $this->conditional ) ) {
				$this->woocommerce_bulk_edit_define_constants();
				$this->woocommerce_bulk_edit_load_class();

				add_filter( 'plugin_action_links_' . WOOCOMMERCE_BULK_EDIT_CONST['basename'], [ $this, 'woocommerce_bulk_edit_setting_link' ] );
				add_action( 'init', [ $this, 'woocommerce_bulk_edit_load_text_domain' ] );
			}
			add_action( 'admin_notices', [ $this, 'woocommerce_bulk_edit_load_admin_notices' ] );
			$this->load_license_functions();
			register_activation_hook( __FILE__, [ $this, 'woocommerce_bulk_edit_active' ] );
		}

		public static function instance() {
			return self::$instance == null ? self::$instance = new self() : self::$instance;
		}

		public function woocommerce_bulk_edit_define_constants() {
			define( 'WOOCOMMERCE_BULK_EDIT_CONST', [
				'version'      => $this->version,
				'slug'         => 'woocommerce-bulk-edit',
				'assets_slug'  => 'woocommerce-bulk-edit-',
				'file'         => __FILE__,
				'basename'     => plugin_basename( __FILE__ ),
				'plugin_dir'   => plugin_dir_path( __FILE__ ),
				'includes_dir' => plugin_dir_path( __FILE__ ) . 'includes' . DIRECTORY_SEPARATOR,
				'admin_dir'    => plugin_dir_path( __FILE__ ) . 'admin' . DIRECTORY_SEPARATOR,
				'dist_dir'     => plugin_dir_path( __FILE__ ) . 'assets' . DIRECTORY_SEPARATOR . 'dist' . DIRECTORY_SEPARATOR,
				'dist_url'     => plugins_url( 'assets/dist/', __FILE__ ),
				'libs_url'     => plugins_url( 'assets/libs/', __FILE__ ),
				'img_url'      => plugins_url( 'assets/img/', __FILE__ ),
				'capability'   => 'manage_woocommerce',
			] );
		}

		public function woocommerce_bulk_edit_load_admin_notices() {
			if ( ! current_user_can( 'manage_options' ) ) {
				return;
			}

			if( ! empty( $this->conditional ) && is_array( $this->conditional ) ){
				foreach ( $this->conditional as $message ) {
					echo sprintf( "<div id='message' class='error'><p>%s</p></div>", esc_html( $message ) );
				}
				unset($_GET['activate']);  // unset this to hide default Plugin activated. notice
	    		deactivate_plugins( plugin_basename( __FILE__ ) , true );
			}
		}

		public function woocommerce_bulk_edit_setting_link( $links ) {
			$editor_link   = [ sprintf( "<a href='%1s' >%2s</a>", esc_url( admin_url( 'admin.php?page=woocommerce-bulk-edit' ) ), esc_html__( 'Manage Products', 'woocommerce-bulk-edit' ) ) ];

			return array_merge( $editor_link,  $links );
		}

		public function woocommerce_bulk_edit_check_conditions() {
			$message = [];

			if( ! class_exists( 'WooCommerce' ) ) {
				$message[] = $this->plugin_name . ' ' . esc_html__( 'requires WooCommerce plugin to be activated.', 'woocommerce-bulk-edit' );
			}

			$this->conditional = $message;
			return $message;
		}

		public function woocommerce_bulk_edit_load_class() {

			if ( ! function_exists( 'WooCommerce_Bulk_Edit_Data' ) ) {
				function WooCommerce_Bulk_Edit_Data() {
					return Data::instance();
				}
			}

			if ( is_admin() ) {
				History::instance();
				Enqueue::instance();
				Admin::instance();
				Editor::instance();
				Ajax::instance();
			}
		}

		public function woocommerce_bulk_edit_load_text_domain() {
			$locale = determine_locale();
			$locale = apply_filters( 'plugin_locale', $locale, 'woocommerce-bulk-edit' );

			unload_textdomain( 'woocommerce-bulk-edit' );
			load_textdomain( 'woocommerce-bulk-edit', WP_LANG_DIR . '/woocommerce-bulk-edit/woocommerce-bulk-edit-' . $locale . '.mo' );
			load_plugin_textdomain( 'woocommerce-bulk-edit', false, plugin_basename( dirname( WOOCOMMERCE_BULK_EDIT_CONST['file'] ) ) . '/languages' );
		}

		public function woocommerce_bulk_edit_active( $network_wide ) {
			global $wpdb;
			$history = History::instance();
			if ( function_exists( 'is_multisite' ) && is_multisite() && $network_wide ) {
				$current_blog = $wpdb->blogid;
				$blogs        = $wpdb->get_col( "SELECT blog_id FROM {$wpdb->blogs}" );
				foreach ( $blogs as $blog ) {
					switch_to_blog( $blog );
					$history->create_database_table();
				}
				switch_to_blog( $current_blog );
			} else {
				$history->create_database_table();
			}
		}

		public function load_license_functions() {

		    // Check if we are on the 'woocommerce-bulk-edit-settings' page using $_GET

				$plugin_license = new Woocommerce_Bulk_Edit_License( $this->plugin_name, $this->version );

				// Plugin license initialize and notices
		        add_action('admin_init', [$plugin_license, 'plugin_updater']);
		        add_action('admin_init', [$plugin_license, 'register_license_option']);
		        add_action('admin_init', [$plugin_license, 'activate_license']);
		        add_action('admin_init', [$plugin_license, 'deactivate_license']);
		        add_action('admin_notices', [$plugin_license, 'admin_notices']);
		        add_action('admin_notices', [$plugin_license, 'license_activation_notices']);
		}
	}

	add_action( 'plugins_loaded', [ 'WooCommerce_Bulk_Edit', 'instance' ] );
}

