<?php

namespace WooCommerceBulkEditor\Includes;

defined( 'ABSPATH' ) || exit;

class Support {

	protected static $instance = null;

	public function __construct() {
		add_action( 'plugins_loaded', [ $this, 'admin_init' ] );
		add_action( 'woocommerce_bulk_edit_admin_field_auto_update_key', [ $this, 'auto_update_key' ] );
	}

	public static function instance() {
		return self::$instance == null ? self::$instance = new self() : self::$instance;
	}

	public function admin_init() {
		$this->support();
	}

	public function support() {
		if ( ! class_exists( 'VillaTheme_Support' ) ) {
			include_once WOOCOMMERCE_BULK_EDIT_CONST['plugin_dir'] . 'support/support.php';
		}

		new \VillaTheme_Support(
			array(
				'support'   => 'https://wordpress.org/support/plugin/woocommerce-bulk-edit',
				'docs'      => 'http://docs.villatheme.com/?item=woocommerce-bulk-edit',
				'review'    => 'https://wordpress.org/support/plugin/woocommerce-bulk-edit/reviews/?rate=5#rate-response',
				'css'       => WOOCOMMERCE_BULK_EDIT_CONST['dist_url'],
				'image'     => WOOCOMMERCE_BULK_EDIT_CONST['img_url'],
				'slug'      => WOOCOMMERCE_BULK_EDIT_CONST['slug'],
				'menu_slug' => 'woocommerce_bulk_edit_bulk_editor',
				'version'   => WOOCOMMERCE_BULK_EDIT_CONST['version'],
				'pro_url'   => WOOCOMMERCE_BULK_EDIT_CONST['pro_url'],
			)
		);
	}

	public function auto_update_key() {
		?>
        <table class="form-table">
            <tr>
                <th>
					<?php esc_html_e( 'Auto update key', 'woocommerce-bulk-edit' ); ?>
                </th>
                <td>
					<?php self::get_pro_version(); ?>
                </td>
            </tr>
        </table>
		<?php
	}

	public static function get_pro_version() {
		printf( '<a class="vi-ui button tiny" href="%s" target="_blank">%s</a>',
			esc_url( WOOCOMMERCE_BULK_EDIT_CONST['pro_url'] ), esc_html__( 'Pro version', 'woocommerce-bulk-edit' ) );
	}

}