<?php

namespace WooCommerceBulkEditor\Includes;

use WooCommerceBulkEditor\Admin\History;

defined( 'ABSPATH' ) || exit;

class Enqueue {

	protected static $instance = null;

	public function __construct() {
		add_action( 'admin_enqueue_scripts', [ $this, 'admin_enqueue_scripts' ] );
		add_action( 'admin_enqueue_scripts', [ $this, 'remove_other_plugin_scripts' ], PHP_INT_MAX );
	}

	public static function instance() {
		return self::$instance == null ? self::$instance = new self() : self::$instance;
	}

	public function register_styles( $styles, $libs = false ) {
		$src    = $libs ? WOOCOMMERCE_BULK_EDIT_CONST['libs_url'] : WOOCOMMERCE_BULK_EDIT_CONST['dist_url'];
		$suffix = $libs ? '.min.css' : '.css';

		$styles = explode( ',', str_replace( ' ', '', $styles ) );
		foreach ( $styles as $style ) {
			wp_register_style( WOOCOMMERCE_BULK_EDIT_CONST['assets_slug'] . $style, $src . $style . $suffix, '', WOOCOMMERCE_BULK_EDIT_CONST['version'] );
		}
	}

	public function register_scripts( $scripts, $libs = false ) {
		$src = $libs ? WOOCOMMERCE_BULK_EDIT_CONST['libs_url'] : WOOCOMMERCE_BULK_EDIT_CONST['dist_url'];
		foreach ( $scripts as $script => $depend ) {
			wp_register_script( WOOCOMMERCE_BULK_EDIT_CONST['assets_slug'] . $script, $src . $script . '.min.js', (array) $depend, WOOCOMMERCE_BULK_EDIT_CONST['version'] );
		}
	}

	public function enqueue_styles( $styles ) {
		$styles = explode( ',', str_replace( ' ', '', $styles ) );
		foreach ( $styles as $style ) {
			wp_enqueue_style( WOOCOMMERCE_BULK_EDIT_CONST['assets_slug'] . $style );
		}
	}

	public function enqueue_scripts( $scripts ) {
		$scripts = explode( ',', str_replace( ' ', '', $scripts ) );
		foreach ( $scripts as $script ) {
			wp_enqueue_script( WOOCOMMERCE_BULK_EDIT_CONST['assets_slug'] . $script );
		}
	}

	public function admin_enqueue_scripts() {
		if ( ! empty( $_GET['page'] ) ) {

			$this->register_styles( 'header,tab,menu,segment,form,table,checkbox,dropdown,transition,popup,accordion,select2,button,input,label,list,dimmer,modal,icon,jsoneditor,jsuite,jexcel', true );

			$this->register_styles( 'editor,settings' );

			$lib_scripts = [
				'transition' => [ 'jquery' ],
				'dropdown'   => [ 'jquery' ],
				'modal'      => [ 'jquery' ],
				'dimmer'     => [ 'jquery' ],
				'select2'    => [ 'jquery' ],
				'accordion'  => [ 'jquery' ],
				'tab'        => [ 'jquery' ],
				'jsuite'     => [],
				'jsoneditor' => [],
			];

			$scripts = [
				'jexcel'   => [ 'jquery'],
				'editor'   => [ 'jquery' ],
				'settings' => [ 'jquery' ]
			];

			$this->register_scripts( $lib_scripts, true );
			$this->register_scripts( $scripts );

			switch ( $_GET['page'] ) {
				case 'woocommerce-bulk-edit':
					wp_enqueue_media();
					wp_enqueue_editor();
					wp_enqueue_script( 'jquery-ui-sortable' );

					$this->enqueue_styles( 'checkbox,accordion,jsoneditor,popup,tab,table,dimmer,modal,label,input,form,header,select2,transition,dropdown,icon,segment,menu,button,jsuite,jexcel,editor' );
					$this->enqueue_scripts( 'accordion,jsoneditor,tab,dimmer,modal,select2,transition,dropdown,jsuite,jexcel,editor' );

					$columns    = WooCommerce_Bulk_Edit_Data()->get_columns_type();
					$id_mapping = array_keys( $columns );
					
					$attribute_taxonomies = wc_get_attribute_taxonomies();

					$attr_data = [];
					foreach ( $attribute_taxonomies as $tax ) {
						$taxonomy = wc_attribute_taxonomy_name( $tax->attribute_name );

						$attr_data[ $taxonomy ]['data'] = (array) $tax;

						if ( taxonomy_exists( $taxonomy ) ) {
							$terms = get_terms( $taxonomy, 'hide_empty=0' );
							foreach ( $terms as $term ) {
								$attr_data[ $taxonomy ]['terms'][ $term->term_id ] = [ 'slug' => $term->slug, 'text' => $term->name ];
							}
						}
					}

					wp_localize_script( WOOCOMMERCE_BULK_EDIT_CONST['assets_slug'] . 'editor', 'wbeParams', [
						'ajaxUrl'       => admin_url( 'admin-ajax.php' ),
						'nonce'         => wp_create_nonce( 'woocommerce_bulk_edit_nonce' ),
						'columns'       => wp_json_encode( array_values( $columns ) ),
						'idMapping'     => $id_mapping,
						'idMappingFlip' => array_flip( $id_mapping ),
						'attributes'    => $attr_data,
						'metaFields'    => get_option( 'woocommerce_bulk_edit_product_meta_fields' ),
						'settings'      => WooCommerce_Bulk_Edit_Data()->get_settings(),
						'historyPages'  => History::instance()->count_history_pages(),
						'adminUrl'      => admin_url(),
						'frontendUrl'   => site_url(),
						'editType'      => 'products'
					] );

					wp_localize_script( WOOCOMMERCE_BULK_EDIT_CONST['assets_slug'] . 'editor', 'wbeI18n', [
						'i18n' => I18n::i18n()
					] );

					break;
			}
		}
	}

	public function remove_other_plugin_scripts() {
		if ( ! empty( $_GET['page'] ) ) {
			if ( in_array( $_GET['page'], [ 'woocommerce_bulk_edit' ] ) ) {
				global $wp_scripts;
				$scripts = $wp_scripts->registered;
				foreach ( $scripts as $k => $script ) {
					if ( strpos( $script->src, WP_CONTENT_URL ) !== false && strpos( $script->handle, WOOCOMMERCE_BULK_EDIT_CONST['assets_slug'] ) === false ) {
						if ( $script->handle === 'query-monitor' ) {
							continue;
						}
						unset( $wp_scripts->registered[ $k ] );
						wp_dequeue_script( $script->handle );
					}
				}

			}
		}
	}
}