<?php

namespace WooCommerceBulkEditor\Admin;


defined( 'ABSPATH' ) || exit;

class Editor {

	protected static $instance = null;
	protected $filter_saved;
	protected $allow_html_tags;

	public function __construct() {
		add_action( 'admin_notices', [ $this, 'remove_notice' ], 1 );
		add_filter( 'admin_body_class', [ $this, 'full_screen_option' ] );
	}

	public static function instance() {
		return self::$instance == null ? self::$instance = new self() : self::$instance;
	}

	public function remove_notice() {
		if ( isset( $_GET['page'] ) && $_GET['page'] === 'woocommerce_bulk_edit_bulk_editor' ) {
			remove_all_actions( 'admin_notices' );
		}
	}

	public function full_screen_option( $body_class ) {
		$full_screen = get_option( 'woocommerce_bulk_edit_full_screen_option' ) ? ' woocommerce-bulk-edit-full-screen ' : '';

		return $body_class . $full_screen;
	}

	public function editor() {
		$user_id = get_current_user_id();
		delete_transient( "woocommerce_bulk_edit_filter_data_{$user_id}" );

		$columns            = WooCommerce_Bulk_Edit_Data()->get_culumns_type_title();
		$this->filter_saved = get_transient( "woocommerce_bulk_edit_filter_data_{$user_id}" );

		$roles = [];
		foreach ( wp_roles()->roles as $role_name => $role_obj ) {
			if ( ! empty( $role_obj['capabilities']['edit_posts'] ) ) {
				$roles[] = $role_name;
			}
		}
		$users = get_users( [ 'role__in' => $roles, 'fields' => [ 'ID', 'display_name' ] ] );

		$users_options = [ '' => esc_html__( 'Author', 'woocommerce-bulk-edit' ) ];
		if ( ! empty( $users ) && is_array( $users ) ) {
			foreach ( $users as $user ) {
				$users_options[ $user->ID ] = $user->display_name;
			}
		}

		$full_screen_icon  = get_option( 'woocommerce_bulk_edit_full_screen_option' ) ? 'window close outline' : 'external';
		$full_screen_title = get_option( 'woocommerce_bulk_edit_full_screen_option' ) ? esc_html__( 'Exit full screen', 'bulky-woocommerce-bulk-edit--products' ) : esc_html__( 'Full screen', 'bulky-woocommerce-bulk-edit--products' );

		?>

        <div id="woocommerce-bulk-edit-container">
        	<h2 style="text-align: center;"><?php esc_html_e( 'WooCommerce Products Bulk Edit', 'woocommerce-bulk-edit' ); ?> </h2>
            <div id="woocommerce-bulk-edit-wrapper">

                <div id="woocommerce-bulk-edit-menu-bar">
                    <div class="vi-ui menu">

                        <a class="item woocommerce-bulk-edit-open-sidebar" data-menu_tab="filter" title="<?php esc_html_e( 'Filter', 'woocommerce-bulk-edit' ); ?>">
                            <i class="filter icon"> </i>
                        </a>

                        <a class="item woocommerce-bulk-edit-open-sidebar" data-menu_tab="settings" title="<?php esc_html_e( 'Settings', 'woocommerce-bulk-edit' ); ?>">
                            <i class="cog icon"> </i> <!--sliders horizontal-->
                        </a>

                        <a class="item woocommerce-bulk-edit-open-sidebar" data-menu_tab="meta_field" title="<?php esc_html_e( 'Meta fields', 'woocommerce-bulk-edit' ); ?>">
                            <i class="server icon"> </i>
                        </a>
                       <!--  <a class="item woocommerce-bulk-edit-open-sidebar" data-menu_tab="history" title="<?php esc_html_e( 'History', 'woocommerce-bulk-edit' ); ?>">
                            <i class="history icon"> </i>
                        </a> -->

                        <a class="item woocommerce-bulk-edit-new-products" title="<?php esc_html_e( 'Add new', 'woocommerce-bulk-edit' ); ?>">
                            <i class="plus icon"> </i>
                        </a>
                        <a class="item woocommerce-bulk-edit-save-button" title="<?php esc_html_e( 'Save', 'woocommerce-bulk-edit' ); ?>">
                            <i class="save icon"> </i>
                        </a>

                        <a class="item woocommerce-bulk-edit-get-product" title="<?php esc_html_e( 'Reload this page', 'woocommerce-bulk-edit' ); ?>">
                            <i class="sync icon"> </i>
                        </a>

                        <a class="item woocommerce-bulk-edit-full-screen-btn" title="<?php echo esc_html( $full_screen_title ) ?>">
                            <i class="<?php echo esc_attr( $full_screen_icon ) ?> icon"> </i>
                        </a>

                        <div class="woocommerce-bulk-edit-menu-bar-center">

                        </div>

                        <div class="woocommerce-bulk-edit-pagination">
                        </div>
                    </div>
                </div>


                <div id="woocommerce-bulk-edit-sidebar" class="vi-ui form small">
                    <div class="woocommerce-bulk-edit-sidebar-wrapper">
                        <span class="woocommerce-bulk-edit-close-sidebar"><i class="dashicons dashicons-no-alt"></i></span>
                        <div class="woocommerce-bulk-edit-sidebar-inner">

                            <div class="vi-ui top attached tabular menu">
                                <a class="active item" data-tab="filter"><?php esc_html_e( 'Filter', 'woocommerce-bulk-edit' ); ?></a>
                                <a class="item" data-tab="settings"><?php esc_html_e( 'Settings', 'woocommerce-bulk-edit' ); ?></a>
                               <!--  <a class="item" data-tab="meta_field"><?php //esc_html_e( 'Meta fields', 'woocommerce-bulk-edit' ); ?></a> -->
                                <!-- <a class="item" data-tab="history"><?php esc_html_e( 'History', 'woocommerce-bulk-edit' ); ?></a> -->
                            </div>

                            <div class="vi-ui bottom attached active tab segment" data-tab="filter">
                                <form class="" id="woocommerce-bulk-edit-products-filter">
									<?php
									$this->filter_input_element( [
										'type'  => 'text',
										'id'    => 'id',
										'label' => esc_html__( 'ID', 'woocommerce-bulk-edit' )
									] );

									$this->filter_input_element( [
										'type'     => 'text',
										'id'       => 'post_title',
										'label'    => esc_html__( 'Title', 'woocommerce-bulk-edit' ),
										'behavior' => true
									] );

									$this->filter_input_element( [
										'type'     => 'text',
										'id'       => 'post_content',
										'label'    => esc_html__( 'Content', 'woocommerce-bulk-edit' ),
										'behavior' => true
									] );

									$this->filter_input_element( [
										'type'     => 'text',
										'id'       => 'post_excerpt',
										'label'    => esc_html__( 'Excerpt', 'woocommerce-bulk-edit' ),
										'behavior' => true
									] );

									$this->filter_input_element( [
										'type'     => 'text',
										'id'       => 'post_name',
										'label'    => esc_html__( 'Slug', 'woocommerce-bulk-edit' ),
										'behavior' => true
									] );

									$this->filter_input_element( [
										'type'     => 'text',
										'id'       => 'sku',
										'label'    => esc_html__( 'SKU', 'woocommerce-bulk-edit' ),
										'behavior' => true
									] );

									?>

                                    <div class="two fields">
										<?php
										$this->filter_input_element( [
											'type'  => 'date',
											'id'    => 'post_date_from',
											'label' => esc_html__( 'Post date from', 'woocommerce-bulk-edit' )
										] );
										$this->filter_input_element( [
											'type'  => 'date',
											'id'    => 'post_date_to',
											'label' => esc_html__( 'Post date to', 'woocommerce-bulk-edit' )
										] );
										?>
                                    </div>

                                    <div class="two fields">
										<?php
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'regular_price_from',
											'label' => esc_html__( 'Regular price from', 'woocommerce-bulk-edit' )
										] );
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'regular_price_to',
											'label' => esc_html__( 'Regular price to', 'woocommerce-bulk-edit' )
										] );
										?>
                                    </div>

                                    <div class="two fields">
										<?php
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'sale_price_from',
											'label' => esc_html__( 'Sale price from', 'woocommerce-bulk-edit' )
										] );
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'sale_price_to',
											'label' => esc_html__( 'Sale price to', 'woocommerce-bulk-edit' )
										] );
										?>
                                    </div>

                                    <div class="two fields">
										<?php
										$this->filter_input_element( [
											'type'  => 'date',
											'id'    => 'sale_date_from',
											'label' => esc_html__( 'Sale date from', 'woocommerce-bulk-edit' )
										] );
										$this->filter_input_element( [
											'type'  => 'date',
											'id'    => 'sale_date_to',
											'label' => esc_html__( 'Sale date to', 'woocommerce-bulk-edit' )
										] );
										?>
                                    </div>

                                    <div class="two fields">
										<?php
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'stock_quantity_from',
											'label' => esc_html__( 'Stock quantity from', 'woocommerce-bulk-edit' )
										] );
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'stock_quantity_to',
											'label' => esc_html__( 'Stock quantity to', 'woocommerce-bulk-edit' )
										] );
										?>
                                    </div>

                                    <div class="two fields">
										<?php
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'width_from',
											'label' => esc_html__( 'Width from', 'woocommerce-bulk-edit' )
										] );
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'width_to',
											'label' => esc_html__( 'Width to', 'woocommerce-bulk-edit' )
										] );
										?>
                                    </div>

                                    <div class="two fields">
										<?php
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'height_from',
											'label' => esc_html__( 'Height from', 'woocommerce-bulk-edit' )
										] );
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'height_to',
											'label' => esc_html__( 'Height to', 'woocommerce-bulk-edit' )
										] );
										?>
                                    </div>

                                    <div class="two fields">
										<?php
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'length_from',
											'label' => esc_html__( 'Lenght from', 'woocommerce-bulk-edit' )
										] );
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'length_to',
											'label' => esc_html__( 'Lenght to', 'woocommerce-bulk-edit' )
										] );
										?>
                                    </div>

                                    <div class="two fields">
										<?php
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'weight_from',
											'label' => esc_html__( 'Weight from', 'woocommerce-bulk-edit' )
										] );
										$this->filter_input_element( [
											'type'  => 'number',
											'id'    => 'weight_to',
											'label' => esc_html__( 'Weight to', 'woocommerce-bulk-edit' )
										] );
										?>
                                    </div>

                                    <div class="two fields">
										<?php
										$this->filter_input_element( [
											'type'    => 'select',
											'id'      => 'type',
											'options' => [ '' => esc_html__( 'Product type', 'woocommerce-bulk-edit' ) ] + wc_get_product_types()
										] );
										$this->filter_input_element( [
											'type'    => 'select',
											'id'      => 'status',
											'options' => [
												''        => esc_html__( 'Product status', 'woocommerce-bulk-edit' ),
												'draft'   => esc_html__( 'Draft', 'woocommerce-bulk-edit' ),
												'pending' => esc_html__( 'Pending', 'woocommerce-bulk-edit' ),
												'private' => esc_html__( 'Private', 'woocommerce-bulk-edit' ),
												'publish' => esc_html__( 'Publish', 'woocommerce-bulk-edit' ),
											]
										] );
										?>
                                    </div>

                                    <div class="two fields">
										<?php
										$this->filter_input_element( [
											'type'    => 'select',
											'id'      => 'stock_status',
											'options' => [ '' => esc_html__( 'Stock status', 'woocommerce-bulk-edit' ) ] + wc_get_product_stock_status_options()
										] );
										$this->filter_input_element( [
											'type'    => 'select',
											'id'      => 'featured',
											'options' => [
												''    => esc_html__( 'Featured', 'woocommerce-bulk-edit' ),
												'yes' => esc_html__( 'Yes', 'woocommerce-bulk-edit' ),
												'no'  => esc_html__( 'No', 'woocommerce-bulk-edit' ),
											]
										] );
										?>
                                    </div>

                                    <div class="two fields">
										<?php
										$this->filter_input_element( [
											'type'    => 'select',
											'id'      => 'downloadable',
											'options' => [
												''    => esc_html__( 'Downloadable', 'woocommerce-bulk-edit' ),
												'yes' => esc_html__( 'Yes', 'woocommerce-bulk-edit' ),
												'no'  => esc_html__( 'No', 'woocommerce-bulk-edit' ),
											]
										] );
										$this->filter_input_element( [
											'type'    => 'select',
											'id'      => 'sold_individually',
											'options' => [
												''    => esc_html__( 'Sold individually', 'woocommerce-bulk-edit' ),
												'yes' => esc_html__( 'Yes', 'woocommerce-bulk-edit' ),
												'no'  => esc_html__( 'No', 'woocommerce-bulk-edit' ),
											]
										] );
										?>
                                    </div>

                                    <div class="two fields">
										<?php
										$this->filter_input_element( [
											'type'    => 'select',
											'id'      => 'backorders',
											'options' => [ '' => esc_html__( 'Backorders', 'woocommerce-bulk-edit' ) ] + wc_get_product_backorder_options()
										] );

										$this->filter_input_element( [
											'type'    => 'select',
											'id'      => 'author',
											'options' => $users_options
										] );
										?>
                                    </div>

									<?php
									$this->filter_input_element( [
										'type'    => 'select',
										'id'      => 'visibility',
										'options' => [ '' => esc_html__( 'Catalog visibility', 'woocommerce-bulk-edit' ) ] + wc_get_product_visibility_options()
									] );

									$this->filter_input_element( [
										'type'        => 'multi-select',
										'id'          => 'product_cat',
										'options'     => [ '' => esc_html__( 'Categories', 'woocommerce-bulk-edit' ) ] + WooCommerce_Bulk_Edit_Data()->get_categories(),
										'name_prefix' => 'taxonomies',
										'operator'    => true,
									] );

									$this->filter_input_element( [
										'type'        => 'multi-select',
										'id'          => 'product_tag',
										'options'     => [ '' => esc_html__( 'Tags', 'woocommerce-bulk-edit' ) ] + WooCommerce_Bulk_Edit_Data()->get_product_tags(),
										'name_prefix' => 'taxonomies',
										'operator'    => true,
									] );

									$attribute_taxonomies = wc_get_attribute_taxonomies();
									foreach ( $attribute_taxonomies as $tax ) {
										$taxonomy = wc_attribute_taxonomy_name( $tax->attribute_name );
										$options  = [];
										if ( taxonomy_exists( $taxonomy ) ) {
											$terms = get_terms( $taxonomy, 'hide_empty=0' );
											foreach ( $terms as $term ) {
												$options[ $term->slug ] = $term->name;
											}
										}

										$this->filter_input_element( [
											'type'        => 'multi-select',
											'id'          => $taxonomy,
											'options'     => [ '' => $tax->attribute_label ] + $options,
											'name_prefix' => 'taxonomies',
											'operator'    => true,
										] );
									}

									?>

                                </form>

                                <div class="woocommerce-bulk-edit-sidebar-footer">
                                    <span class="vi-ui button small woocommerce-bulk-edit-apply-filter">
                                        <?php esc_html_e( 'Filter', 'woocommerce-bulk-edit' ); ?>
                                    </span>
                                    <span class="vi-ui button small woocommerce-bulk-edit-clear-filter">
                                        <?php esc_html_e( 'Clear', 'woocommerce-bulk-edit' ); ?>
                                    </span>
                                </div>

                            </div>

                            <div class="vi-ui bottom attached tab segment" data-tab="settings">
                                <form class="woocommerce-bulk-edit-settings-tab ">

									<?php
									$this->setting_input_element( [
										'type'         => 'multi-select',
										'id'           => 'edit_fields',
										'select_class' => 'woocommerce-bulk-edit-select-columns-to-edit woocommerce-bulk-edit-select2 search',
										'label'        => esc_html__( 'Fields to edit', 'woocommerce-bulk-edit' ),
										'options'      => [ '' => esc_html__( 'All fields', 'woocommerce-bulk-edit' ) ] + $columns,
										'clear_button' => true
									] );

									$this->setting_input_element( [
										'type'         => 'multi-select',
										'id'           => 'exclude_edit_fields',
										'select_class' => 'woocommerce-bulk-edit-exclude-fields-to-edit woocommerce-bulk-edit-select2 search',
										'label'        => esc_html__( 'Exclude fields to edit', 'woocommerce-bulk-edit' ),
										'options'      => [ '' => esc_html__( 'No field', 'woocommerce-bulk-edit' ) ] + $columns,
										'clear_button' => true
									] );

									$this->setting_input_element( [
										// 'type'  => 'get_pro_version',
										'id'    => 'products_per_page',
										'min'   => 1,
										'max'   => 50,
										'label' => esc_html__( 'Products per page (default: 10)', 'woocommerce-bulk-edit' )
									] );

									$this->setting_input_element( [
										'type'    => 'select',
										'id'      => 'load_variations',
										'label'   => esc_html__( 'Load variations', 'woocommerce-bulk-edit' ),
										'options' => [
											'yes' => esc_html__( 'Yes', 'woocommerce-bulk-edit' ),
											'no'  => esc_html__( 'No', 'woocommerce-bulk-edit' ),
										]
									] );

									$this->setting_input_element( [
										'type'    => 'select',
										'id'      => 'order_by',
										'label'   => esc_html__( 'Order by', 'woocommerce-bulk-edit' ),
										'options' => [
											'ID'    => 'ID',
											'title' => esc_html__( 'Title', 'woocommerce-bulk-edit' ),
											'price' => esc_html__( 'Price', 'woocommerce-bulk-edit' ),
											'sku'   => esc_html__( 'SKU', 'woocommerce-bulk-edit' ),
										]
									] );

									$this->setting_input_element( [
										'type'    => 'select',
										'id'      => 'order',
										'label'   => esc_html__( 'Order', 'woocommerce-bulk-edit' ),
										'options' => [ 'DESC' => 'DESC', 'ASC' => 'ASC', ]
									] );

									$this->setting_input_element( [
										// 'type'  => 'get_pro_version',
										'id'    => 'auto_save_revision',
										'min'   => 0,
										'max'   => 1000,
										'label' => esc_html__( 'Time to save revision', 'woocommerce-bulk-edit' ),
										'unit'  => esc_html__( 'second(s)', 'woocommerce-bulk-edit' ),
									] );

									$this->setting_input_element( [
										// 'type'  => 'get_pro_version',
										'id'    => 'auto_remove_revision',
										'min'   => 0,
										'max'   => 1000,
										'label' => esc_html__( 'Time to delete revision', 'woocommerce-bulk-edit' ),
										'unit'  => esc_html__( 'day(s)', 'woocommerce-bulk-edit' ),
									] );

									$this->setting_input_element( [
										// 'type'  => 'get_pro_version',
										'id'    => 'save_filter',
										'label' => esc_html__( 'Save filter when reload page', 'woocommerce-bulk-edit' ),
									] );

									$this->setting_input_element( [
										'type'  => 'checkbox',
										'id'    => 'variation_filter',
										'label' => esc_html__( 'Filter include variation', 'bulky-woocommerce-bulk-edit--products' ),
									] );
									?>
                                </form>

                                <div class="woocommerce-bulk-edit-sidebar-footer">
                                    <span class="vi-ui button small woocommerce-bulk-edit-save-settings">
                                        <?php esc_html_e( 'Save', 'woocommerce-bulk-edit' ); ?>
                                    </span>
                                </div>

                            </div>

                            <!-- <div class="vi-ui bottom attached tab segment" data-tab="meta_field">
								<?php //esc_html_e( 'Not Available', 'woocommerce-bulk-edit') ?>
                            </div> -->

                            <div class="vi-ui bottom attached tab segment" data-tab="history">
                                <div class="vi-ui form mini">

                                    <div>
                                        <div class="vi-wbe-history-menu-left">
                                        </div>
                                        <div class="vi-wbe-history-menu-right">
                                            <div class="vi-wbe-pagination"><div class="vi-ui pagination menu"><a class="item disabled" data-page="0"><i class="icon angle left"> </i></a>  <a class="item " data-page="2"><i class="icon angle right"> </i></a> </div> <input type="number" class="vi-wbe-go-to-page" value="1" min="1" max="0"></div>
                                        </div>
                                    </div>

                                    <table id="vi-wbe-history-points-list" class="vi-ui celled table">
                                        <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>User</th>
                                            <th class="">Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>

                                </div>

                                <div class="vi-wbe-history-review vi-ui form mini">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="woocommerce-bulk-edit-editor" class="vi-ui segment">
                    <div class="wvps-scroll">

                        <div id="woocommerce-bulk-edit-spreadsheet">

                        </div>
                    </div>
                </div>

            </div>

            <!------------------- Modal ---------------------->
            <div class="vi-ui modal">
                <i class="close icon"></i>

                <div class="scrolling content woocommerce-bulk-edit-editing" style="box-sizing: border-box;height: 5000px">
                    <div>
                        <textarea id="woocommerce-bulk-edit-text-editor"></textarea>
                    </div>
                </div>

                <div class="actions woocommerce-bulk-edit-editing">
                    <!--                    <div class="vi-ui button tiny woocommerce-bulk-edit-text-editor-save woocommerce-bulk-edit-next">-->
                    <!--						--><?php //esc_html_e( 'Next', 'woocommerce-bulk-edit' ); ?>
                    <!--                    </div>-->
                    <div class="vi-ui button tiny woocommerce-bulk-edit-text-editor-save">
						<?php esc_html_e( 'Save', 'woocommerce-bulk-edit' ); ?>
                    </div>
                    <div class="vi-ui button tiny woocommerce-bulk-edit-text-editor-save woocommerce-bulk-edit-close">
						<?php esc_html_e( 'Save & Close', 'woocommerce-bulk-edit' ); ?>
                    </div>
                </div>
            </div>

            <div class=" vi-ui segment form woocommerce-bulk-edit-context-popup"></div>

        </div>
		<?php
	}

	public function filter_input_element( $args = [] ) {
		$args = wp_parse_args( $args, [
			'type'         => '',
			'id'           => '',
			'label'        => '',
			'behavior'     => '',
			'operator'     => '',
			'name_prefix'  => '',
			'class'        => '',
			'placeholder'  => '',
			'label_class'  => 'woocommerce-bulk-edit-filter-label',
			'input_class'  => 'woocommerce-bulk-edit-filter-input',
			'select_class' => 'woocommerce-bulk-edit-filter-select',
			'more_content' => '',
			'unit'         => ''
		] );

		if ( in_array( $args['type'], [ 'text', 'number', 'date' ] ) ) {
			$args['class'] .= 'woocommerce-bulk-edit-filter-input-scope';
		}

		if ( $args['behavior'] ) {
			$args['more_content'] = $this->behavior_ui( $args['id'] );
			$args['action_class'] = 'action';
		}

		if ( $args['operator'] ) {
			$args['more_content'] = $this->operator_ui( $args['id'] );
			$args['action_class'] = 'action';
		}

		if ( $args['unit'] ) {
			$args['more_content'] = sprintf( "<div class='vi-ui basic label'>%s</div>", esc_html( $args['unit'] ) );
		}

		if ( $args['name_prefix'] ) {
			$value = $this->filter_saved[ $args['name_prefix'] ][ $args['id'] ] ?? ( $this->filter_saved[ $args['id'] ] ?? '' );
		} else {
			$value = $this->filter_saved[ $args['id'] ] ?? '';
		}

		$this->core_elements( $args, $value );
	}

	public function setting_input_element( $args ) {
		$args = wp_parse_args( $args, [
			'type'         => '',
			'id'           => '',
			'default'      => '',
			'label'        => '',
			'behavior'     => '',
			'operator'     => '',
			'name_prefix'  => '',
			'class'        => '',
			'label_class'  => '',
			'input_class'  => '',
			'select_class' => '',
			'more_content' => '',
			'unit'         => '',
			'clear_button' => ''
		] );

		if ( $args['unit'] ) {
			$args['more_content'] = sprintf( "<div class='vi-ui basic label'>%s</div>", esc_html( $args['unit'] ) );
			$args['action_class'] = 'right labeled';
		}

		$data  = WooCommerce_Bulk_Edit_Data()->get_settings();
		$value = $data[ $args['id'] ] ?? '';
		$this->core_elements( $args, $value );
	}

	public function core_elements( $args, $value ) {
		if ( ! $this->allow_html_tags ) {
			$this->allow_html_tags = wp_parse_args(
				[
					'input'  => [ 'class' => true, 'name' => true ],
					'select' => [ 'class' => true, 'name' => true, 'multiple' => true ],
					'option' => [ 'value' => true, 'selected' => true ],
					'div'    => [ 'value' => true, 'class' => true ]
				],
				wp_kses_allowed_html() );
		}

		?>
        <div class="field <?php echo esc_attr( $args['class'] ) ?>">
			<?php
			switch ( $args['type'] ) {
				case 'text':
				case 'number':
				case 'date':
					$min = isset( $args['min'] ) ? " min={$args['min']}" : '';
					$max = isset( $args['max'] ) ? " max={$args['max']}" : '';
					?>
                    <label class="<?php echo esc_attr( $args['label_class'] ) ?>">
						<?php echo esc_attr( $args['label'] ) ?>
                    </label>
                    <div class="vi-ui input small <?php echo esc_attr( $args['action_class'] ?? '' ); ?>">
                        <input type="<?php echo esc_attr( $args['type'] ) ?>" placeholder="<?php echo esc_attr( $args['placeholder'] ) ?>"
                               name="<?php echo esc_attr( $args['id'] ) ?>"
                               value="<?php echo esc_attr( $value ) ?>"
                               class="<?php echo esc_attr( $args['input_class'] ) ?>" <?php echo esc_attr( $min . $max ) ?>>
						<?php echo wp_kses( $args['more_content'], $this->allow_html_tags ); ?>
                    </div>
					<?php
					break;

				case 'select':
				case 'multi-select':
					$multiple = $args['type'] == 'multi-select' ? 'multiple' : '';
					$name = $args['name_prefix'] ? $args['name_prefix'] . "[{$args['id']}]" : $args['id'];
					$name = $multiple ? $name . '[]' : $name;
					?>
                    <label class="<?php echo esc_attr( $args['label_class'] ) ?>">
						<?php echo esc_attr( $args['label'] ) ?>
                    </label>
                    <div class="vi-ui input small <?php echo esc_attr( $args['action_class'] ?? '' ); ?>">
                        <select id="woocommerce-bulk-edit-<?php echo esc_attr( $args['id'] ?? '' ) ?>"
                                name="<?php echo esc_attr( $name ) ?>"
                                class="vi-wbe vi-ui fluid dropdown <?php echo esc_attr( $args['select_class'] ) ?>"
                                data-placeholder="" <?php echo esc_attr( $multiple ) ?> >
							<?php
							if ( ! empty( $args['options'] ) && is_array( $args['options'] ) ) {
								foreach ( $args['options'] as $key => $label ) {
									if ( $multiple && is_array( $value ) ) {
										$selected = in_array( $key, $value ) ? 'selected' : '';
									} else {
										$selected = $key == $value ? 'selected' : '';
									}
									printf( "<option value='%s' %s>%s</option>", esc_attr( $key ), esc_attr( $selected ), esc_html( $label ) );
								}
							}
							?>
                        </select>
						<?php
						if ( ! empty( $args['clear_button'] ) ) {
							?>
                            <span class="woocommerce-bulk-edit-multi-select-clear"><i class="dashicons dashicons-no-alt"> </i></span>
							<?php
						}
						?>
						<?php echo wp_kses( $args['more_content'], $this->allow_html_tags ); ?>
                    </div>
					<?php
					break;

				case 'checkbox':
					?>
                    <label class="<?php echo esc_attr( $args['label_class'] ) ?>">
						<?php echo esc_attr( $args['label'] ) ?>
                    </label>
                    <div class="vi-ui toggle checkbox small <?php echo esc_attr( $args['action_class'] ?? '' ); ?>">
                        <input type="checkbox"
                               name="<?php echo esc_attr( $args['id'] ) ?>"
                               value="1" <?php checked( $value, 1 ) ?>
                               class="<?php echo esc_attr( $args['input_class'] ) ?>">
                        <label> </label>
						<?php echo wp_kses( $args['more_content'], $this->allow_html_tags ); ?>
                    </div>
					<?php
					break;
			}
			?>
        </div>
		<?php

	}

	public function behavior_ui( $id ) {
		$behaviors = [
			'like'  => esc_html__( 'Like', 'woocommerce-bulk-edit' ),
			'exact' => esc_html__( 'Exact', 'woocommerce-bulk-edit' ),
			'not'   => esc_html__( 'Not', 'woocommerce-bulk-edit' ),
			'begin' => esc_html__( 'Begin', 'woocommerce-bulk-edit' ),
			'end'   => esc_html__( 'End', 'woocommerce-bulk-edit' ),
			'empty' => esc_html__( 'Empty', 'woocommerce-bulk-edit' ),
		];

		$saved_behavior = $this->filter_saved['behavior'][ $id ] ?? '';
		ob_start();
		?>
        <select class="vi-ui compact selection dropdown" name="behavior[<?php echo esc_attr( $id ) ?>]">
			<?php
			foreach ( $behaviors as $behavior => $show ) {
				printf( '<option value="%s" %s>%s</option>', esc_attr( $behavior ), selected( $behavior, $saved_behavior, false ), esc_html( $show ) );
			}
			?>
        </select>
		<?php
		return ob_get_clean();
	}

	public function operator_ui( $id ) {
		$operators      = [
			'or'     => esc_html__( 'Or', 'woocommerce-bulk-edit' ),
			'and'    => esc_html__( 'And', 'woocommerce-bulk-edit' ),
			'not_in' => esc_html__( 'Not in', 'woocommerce-bulk-edit' ),
		];
		$saved_operator = $this->filter_saved['operator'][ $id ] ?? '';
		ob_start();
		?>
        <select class="vi-ui compact selection dropdown" name="operator[<?php echo esc_attr( $id ) ?>]">
			<?php
			foreach ( $operators as $operator => $show ) {
				printf( '<option value="%s" %s>%s</option>',
					esc_attr( $operator ), selected( $operator, $saved_operator, false ), esc_html( $show ) );
			}
			?>
        </select>
		<?php
		return ob_get_clean();
	}
}