<?php

namespace WooCommerceBulkEditor\Admin;

defined( 'ABSPATH' ) || exit;

class Admin {

	protected static $instance = null;

	public function __construct() {
		add_action( 'admin_menu', [ $this, 'admin_menu' ] );		
	}

	public static function instance() {
		return self::$instance == null ? self::$instance = new self() : self::$instance;
	}

	public function admin_menu() {

		add_menu_page(
            esc_html__('Products Bulk Edit', 'woocommerce-bulk-edit'),
            esc_html__('Products Bulk Edit', 'woocommerce-bulk-edit'),
            WOOCOMMERCE_BULK_EDIT_CONST['capability'],
            WOOCOMMERCE_BULK_EDIT_CONST['slug'],
            [ Editor::instance(), 'editor' ],
            'dashicons-table-row-after',
            26
        );

		add_submenu_page( 
			'woocommerce',
			esc_html__( 'Products Bulk Edit', 'woocommerce-bulk-edit' ),
			esc_html__( 'Products Bulk Edit', 'woocommerce-bulk-edit' ),
			WOOCOMMERCE_BULK_EDIT_CONST['capability'],
			WOOCOMMERCE_BULK_EDIT_CONST['slug'],
			[ Editor::instance(), 'editor' ]
		);

        add_submenu_page(
            WOOCOMMERCE_BULK_EDIT_CONST['slug'],
            esc_html__('License', 'woocommerce-bulk-edit'),
            esc_html__('License', 'woocommerce-bulk-edit'),
            WOOCOMMERCE_BULK_EDIT_CONST['capability'],
            WOOCOMMERCE_BULK_EDIT_CONST['slug'] . '-settings',
            [$this, 'settings_callback']
        );
	}

	public function settings_callback() {
		// Include the template file
        include_once(plugin_dir_path(__FILE__) . 'views/license.php');
	}
}