<?php
/**
 * Abort if this file is accessed directly.
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

global $wp_roles;
$all_roles = $wp_roles->roles;

$show_options = get_option( 'course_scheduler_ld_addon_setting' );
$show_timezone = get_option( 'course_scheduler_ld_time_zone' );
$csld_hide_all_users = get_option( 'course_scheduler_ld_addon_hide_all_users' );
$show_courses = ! empty( $show_options ) ? $show_options : 'show' ;
$send_course_availability_email = get_option( 'ld_cms_send_course_availability_email', 'no') == 'yes';
$ld_cms_hide_unavailable_courses = get_option( 'ld_cms_hide_unavailable_courses', 'no') == 'yes';
$ld_cms_group_roles_schedule = get_option( 'ld_cms_group_roles_schedule', []);
$ld_cms_group_selected_roles_manage_their_courses = get_option( 'ld_cms_group_selected_roles_manage_their_courses', 'no') == 'yes';
$ld_cms_schedule_excluded_user_roles = get_option( 'ld_cms_schedule_excluded_user_roles', []);
/**
 * Generates Time Zones List
 * @param selected time zone t show
 * @return HTML Formated Options to show
 */
function generate_timezone_list( $show_timezone ) {
    static $allRegions = array(
        DateTimeZone::AFRICA,
        DateTimeZone::AMERICA,
        DateTimeZone::ANTARCTICA,
        DateTimeZone::ASIA,
        DateTimeZone::ATLANTIC,
        DateTimeZone::AUSTRALIA,
        DateTimeZone::EUROPE,
        DateTimeZone::INDIAN,
        DateTimeZone::PACIFIC
    );
    // Makes it easier to create option groups next
    $list = array ('AFRICA','AMERICA','ANTARCTICA','ASIA','ATLANTIC','AUSTRALIA','EUROPE','INDIAN','PACIFIC');
    // Make array holding the regions (continents), they are arrays w/ all their cities
    $region = array();
    foreach ( $allRegions as $area ){
        array_push ( $region, DateTimeZone::listIdentifiers( $area ));
    }  

    $count = count ( $region ); 
    $i = 0; 
    $holder = '';
    $holder .= "<option value=''>". __( 'Please Select Time Zone', 'cs_ld_addon' )."</option>";
    $holder .= '<optgroup label="---------- '.'UTC'.' ----------">';
    $sel = ( 'UTC' == $show_timezone )?" selected":"";
    $key = 'UTC';
    $val = '(UTC) Coordinated Universal Time';
    $holder .= "<option value='".$key."'".$sel.">".$val."</option>";
    $holder .= '</optgroup>';
    while ( $i < $count ) {
        $chunck = $region[$i];
        // Create the region (continents) option group
        $holder .= '<optgroup label="---------- '.$list[$i].' ----------">';
        $timezone_offsets = array();
        foreach( $chunck as $timezone ) {
            $tz = new DateTimeZone( $timezone );
            $timezone_offsets[ $timezone ] = $tz->getOffset( new DateTime );
        }
        asort ( $timezone_offsets );
        $timezone_list = array();
        foreach ( $timezone_offsets as $timezone => $offset ) {
            $offset_prefix = $offset < 0 ? '-' : '+';
            $offset_formatted = gmdate( 'H:i', abs($offset) );
            $pretty_offset = "UTC ${offset_prefix}${offset_formatted}";
            $timezone_list[$timezone] = "(${pretty_offset}) $timezone";     
        }
    
        foreach ( $timezone_list as $key => $val ) {
            $sel = ( $key == $show_timezone )?" selected":"";
            $holder .= "<option value='".$key."'".$sel.">".$val."</option>";
        }
        $holder .= '</optgroup>';
        ++$i;
    }
    return $holder;
}

?>
<div id="general_settings" class="cs_ld_tabs ARwebcrafts_addon_plnr-crse"> 
    <div class="ldcpp-loader-ovrly-pnl">
	<div class="ldcpp-loader-ovrly"></div>
</div>
    <form method="POST">
        <table class="setting-table-wrapper">
            <tbody>
                <tr>
                    <td class="qst-mrk-tbla-crse-plnr">
                        <label for="maintenance_mode_level_off">
                            <?php echo __('Show ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'courses' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'topics' ) ) . ',  ' . strtolower( LearnDash_Custom_Label::get_label( 'quizzes' ) ) . __( ' on the specified dates', 'cs_ld_addon'); ?>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description">
                            <?php echo __('Set this option if you want to show the ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'courses' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'topics' ) ) . ',  ' . strtolower( LearnDash_Custom_Label::get_label( 'quizzes' ) ) . __( ' *content* "only" on the dates set on the calendar.', 'cs_ld_addon'); ?>
                        </p>
                    </td>
                    <td>
                        <input type="radio" id="show_courses_on_schedule" name="show_courses" value="show" <?php if( $show_courses == "show" ) echo 'checked="checked"'; ?>>
                    </td>
                </tr>
                <tr>
                    <td class="qst-mrk-tbla-crse-plnr">
                        <label for="maintenance_mode_level_on"><?php echo __('Hide ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'courses' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'topics' ) ) . ',  ' . strtolower( LearnDash_Custom_Label::get_label( 'quizzes' ) ) . __( ' on the specified dates', 'cs_ld_addon'); ?>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description">
                            <?php echo __('Set this option if you want to hide the ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'courses' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'topics' ) ) . ',  ' . strtolower( LearnDash_Custom_Label::get_label( 'quizzes' ) ) . __( ' *content* on the dates set on the calendar.', 'cs_ld_addon' ); ?>
                        </p>
                    </td>
                    <td>
                        <input type="radio" id="do_not_show_courses_on_schedule" name="show_courses" value="hide" <?php if( $show_courses == "hide" ) echo 'checked="checked"'; ?>>
                    </td>
                </tr>
                <tr>
                    <td class="qst-mrk-tbla-crse-plnr">
                        <label for="maintenance_mode_level_on"><?php echo __('Hidden for All Users', 'cs_ld_addon'); ?>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description">
                            <?php echo __('Set this option if you want to hide the ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'courses' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'topics' ) ) . ',  ' . strtolower( LearnDash_Custom_Label::get_label( 'quizzes' ) ) . __( ' *content* to users which do not fall in the allowed user list.', 'cs_ld_addon' ); ?>
                        </p>
                    </td>
                    <td>
                        <input type="checkbox" name="csld_hide_all_users" id="csld_hide_all_users" <?php echo ($csld_hide_all_users=='yes'?'checked':''); ?> value="yes"/>
                    </td>
                </tr>
                <tr>
                    <td class="qst-mrk-tbla-crse-plnr">
                        <label><?php echo __('Send Course Availability Email', 'cs_ld_addon'); ?>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description">
                            <?php echo sprintf(__('Enable this option to send %s availability email to enrolled users, for their scheduled %s', 'cs_ld_addon' ), strtolower(LearnDash_Custom_Label::get_label('course')), strtolower(LearnDash_Custom_Label::get_label('courses'))); ?>
                        </p>
                    </td>
                    <td>
                        <input type="checkbox" name="ld_cms_send_availability_email" id="ld_cms_send_availability_email" value="yes" <?php checked($send_course_availability_email, true); ?> />
                    </td>
                </tr>
                <tr>
                    <td class="qst-mrk-tbla-crse-plnr">
                        <label><?php echo __('Hide Unavailable Courses', 'cs_ld_addon'); ?>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description">
                            <?php echo sprintf(__('Enable this option to hide unavailable scheduled %s from %s listing page(s)', 'cs_ld_addon' ), strtolower(LearnDash_Custom_Label::get_label('courses')), strtolower(LearnDash_Custom_Label::get_label('course'))); ?>
                        </p>
                    </td>
                    <td>
                        <input type="checkbox" name="ld_cms_hide_unavailable_courses" id="ld_cms_hide_unavailable_courses" value="yes" <?php checked($ld_cms_hide_unavailable_courses, true); ?> />
                    </td>
                </tr>
               <!--  <tr>
                    <td style="width:100px;" align="left"><strong><label align="left" for="ld_cms_timezone_string"><?php //_e( 'Time Zone', 'cs_ld_addon' ); ?></label></strong></td>
                    <td>
                        <select name="ld_cms_timezone_string" id="ld_cms_timezone_string" ><?php // echo wp_timezone_choice(get_option('course_scheduler_ld_time_zone', '')); ?> </select>
                        <p class="description" style="font-weight: normal;">
                            <?php // echo __('Set this option if you want to show/hide the ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'courses' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'topics' ) ) . ',  ' . strtolower( LearnDash_Custom_Label::get_label( 'quizzes' ) ) . __( ' *content* according to the specified time zone.', 'cs_ld_addon' ); ?>
                        </p>
                    </td>
                </tr> -->
                <tr>
                    <td class="qst-mrk-tbla-crse-plnr">
                    <label><?php _e( 'Allow user roles to schedule courses', 'cs_ld_addon' ); ?>
                        <i class="fas fa-question"></i>
                    </label>
                    <p class="description">
                            <?php echo __('Selected user roles can schedule the courses from the frontend.', 'cs_ld_addon' ); ?>
                        </p>
                </td>
                    <td>
                        <select id="ld-cms-group-roles-schedule" multiple name="ld_cms_group_roles_schedule[]">
							
                            <?php
							
								foreach( $all_roles as $key=>$role ) {
                                    $selected = '';
                                    if(is_array( $ld_cms_group_roles_schedule) && in_array( $key, $ld_cms_group_roles_schedule ) ) {
                                        $selected = 'selected="selected"';
                                    }
									echo '<option value="'.$key.'" '.$selected.'>'.$role['name'].'</option>';
								}
								
							?>
                        </select>
                        
                    </td>
                </tr>  
                <tr>

                    <td class="qst-mrk-tbla-crse-plnr">
                                            <label class="ld_cms_group_selected_roles_manage_their_courses"><?php echo __('Allow selected user roles to manage their courses only', 'cs_ld_addon'); ?>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description ld_cms_group_selected_roles_manage_their_courses">
                            <?php echo __('If the option is selected then selected roles can manage their own courses otherwise can manage all of the group courses', 'cs_ld_addon' ); ?>
                        </p>
                    </td>
                    <td>
                        <input type="checkbox" class="ld_cms_group_selected_roles_manage_their_courses"
                            name="ld_cms_group_selected_roles_manage_their_courses"
                            id="ld_cms_group_selected_roles_manage_their_courses" value="yes"
                            <?php checked($ld_cms_group_selected_roles_manage_their_courses, true); ?> />
                    </td>
                </tr>
                <tr> 
                    <td class="qst-mrk-tbla-crse-plnr">
                        <label><?php _e( 'Exclude user roles from scheduling', 'cs_ld_addon' ); ?>
                        <i class="fas fa-question"></i>
                    </label>
                     <p class="description">
                            <?php echo __('The Selected user roles will be excluded from scheduling so they will be able to view all unavaliable courses.', 'cs_ld_addon' ); ?>
                        </p>
                </td>
                    <td>
                        <select id="ld-cms-schedule-excluded-roles" multiple
                            name="ld_cms_schedule_excluded_user_roles[]">
							
                            <?php
							
								foreach( $all_roles as $key=>$role ) {
                                    $selected = '';
                                    if(is_array( $ld_cms_schedule_excluded_user_roles ) && in_array( $key, $ld_cms_schedule_excluded_user_roles ) ) {
                                        $selected = 'selected="selected"';
                                    }
									echo '<option value="'.$key.'" '.$selected.'>'.$role['name'].'</option>';
								}
								
							?>
                        </select>
                       
                    </td>    
                </tr>                    
            </tbody>
        </table>
        <div class="submit-button">
            <input type="submit" id="save_csld_general_settings" name="save_csld_general_settings"
                class="cs-ld-addon-btn" value="<?php _e('Update Settings', 'cs_ld_addon'); ?>">
        </div>
        <?php wp_nonce_field( 'csld_general_settings', 'csld_general_settings_field' ); ?>
    </form>
</div>