<?php
/**
 * Settings tab Quiz Completion
 */

/**
 * Abort if this file is accessed directly.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$db_form_fields = get_course_availability_email_settings();
?>
<div class="cs_ld_tabs ARwebcrafts_addon_plnr-crse">

    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
        <input type="hidden" name="action" value="save_ld_cms_settings">
        <table class="form-table">
            <tbody>
            <tr>
                <th scope="row"><label for="ld_cms_availability_email_subject"><?php _e('Email Subject', 'cs_ld_addon')?></label></th>
                <td >
					<?php echo sprintf('<input type="text" value="%s" id="ld_cms_availability_email_subject" name="ld_cms_availability_email_subject" class="regular-text">', esc_html($db_form_fields['subject'])); ?>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="ld_cms_availability_email_message"><?php _e('Email Message', 'cs_ld_addon')?></label></th>
                <td >
					<?php wp_editor( wp_specialchars_decode($db_form_fields['message']), "ld_cms_availability_email_message", $settings = array('textarea_rows' => 6) ); ?>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="ld_cms_availability_email_before"><?php _e('Send Email Before', 'cs_ld_addon'); ?></label></th>
                <td>
                    <input type="number" min="1" name="ld_cms_availability_email_interval" value="<?php echo $db_form_fields['interval']; ?>">
                            
                                <select name="ld_cms_availability_email_interval_unit">
                                    <option value="day" <?php selected($db_form_fields['interval_unit'], 'day'); ?>><?php _e('Day','cs_ld_addon'); ?></option>
                                    <option value="week" <?php selected($db_form_fields['interval_unit'], 'week'); ?>><?php _e('Week','cs_ld_addon'); ?></option>
                                    <option value="month" <?php selected($db_form_fields['interval_unit'], 'month'); ?>><?php _e('Month','cs_ld_addon'); ?></option>
                                </select>
                            
                    <p class="description"><?php _e('Set interval before course availability email is sent', 'cs_ld_addon'); ?></p>
                </td>
            </tr>
            </tbody>
        </table>


        <div class="submit">
            <input type="submit" name="save_ld_cms_settings" class="button-primary" value="<?php _e('Update Settings', 'cs_ld_addon' ); ?>">
        </div>
		<?php wp_nonce_field( 'save_ld_cms_settings_nonce' ); ?>
    </form>

    

    <h2 class="email-av-title"><?php _e('Email subject and message can be personalize by using following placeholders:', 'cs_ld_addon'); ?></h2>
    <div class="crse-av-shrtcode-row">
    

    <div class="crse-av-shrtcode">
        <h3><?php _e('Receiver username', 'cs_ld_addon' ); ?></h3>
        <p> <?php _e('Example:', 'cs_ld_addon' ); ?><em> <strong><?php _e('john_doe', 'cs_ld_addon' ); ?></strong></em></p>
    <div class="crse-av_shortcode_box">
        <code>[user_login]</code>
            <button class="crse-lrn_woo_copy-button">
                <span class="dashicons dashicons-admin-page"></span>
            </button>
        </div>
    </div>

    <div class="crse-av-shrtcode">
        <h3><?php _e('Course title', 'cs_ld_addon' ); ?></h3>
        <p> <?php _e('Example:', 'cs_ld_addon' ); ?><em> <strong><?php _e('Physics Course', 'cs_ld_addon' ); ?></strong></em></p>
    <div class="crse-av_shortcode_box">
        <code>[course]</code>
            <button class="crse-lrn_woo_copy-button">
                <span class="dashicons dashicons-admin-page"></span>
            </button>
        </div>
    </div>

    <div class="crse-av-shrtcode">
        <h3><?php _e('Course title with appended link', 'cs_ld_addon' ); ?></h3>
        <p> <?php _e('Example:', 'cs_ld_addon' ); ?><em> <strong><a href="#"><?php _e('Physics Course', 'cs_ld_addon' ); ?></a></strong></em></p>
    <div class="crse-av_shortcode_box">
        <code>[course_with_link]</code>
            <button class="crse-lrn_woo_copy-button">
                <span class="dashicons dashicons-admin-page"></span>
            </button>
        </div>
    </div>

    <div class="crse-av-shrtcode">
        <h3><?php _e('Course scheduled availability', 'cs_ld_addon' ); ?></h3>
        <p> <?php _e('Example:', 'cs_ld_addon' ); ?> <em><strong><?php _e('Available', 'cs_ld_addon' ); ?></strong>/<strong><?php _e('Unavailable', 'cs_ld_addon' ); ?></strong></em></p>
    <div class="crse-av_shortcode_box">
        <code>[schedule_availability]</code>
            <button class="crse-lrn_woo_copy-button">
                <span class="dashicons dashicons-admin-page"></span>
            </button>
        </div>
    </div>

    <div class="crse-av-shrtcode">
        <h3><?php _e('Course scheduled datetime range', 'cs_ld_addon' ); ?></h3>
        <p> <?php _e('Example:', 'cs_ld_addon' ); ?><em> <strong> <?php echo date('F jS, Y g:i A', strtotime('2020-05-01')); ?> <?php _e('to', 'cs_ld_addon' ); ?> <?php echo date('F jS, Y g:i A', strtotime('2020-05-01')); ?></strong></em></p>
    <div class="crse-av_shortcode_box">
        <code>[schedule_datetime]</code>
            <button class="crse-lrn_woo_copy-button">
                <span class="dashicons dashicons-admin-page"></span>
            </button>
        </div>
    </div>

    <div class="crse-av-shrtcode">
        <h3><?php _e('Course scheduled start datetime', 'cs_ld_addon' ); ?></h3>
        <p> <?php _e('Example:', 'cs_ld_addon' ); ?><em> <strong> <?php _e('from', 'cs_ld_addon' ); ?> <?php echo date('F jS, Y g:i A', strtotime('2020-05-01')); ?></strong></em></p>
    <div class="crse-av_shortcode_box">
        <code>[schedule_datetime_start_only]</code>
            <button class="crse-lrn_woo_copy-button">
                <span class="dashicons dashicons-admin-page"></span>
            </button>
        </div>
    </div>

    <div class="crse-av-shrtcode">
        <h3><?php _e('Course scheduled end datetime', 'cs_ld_addon' ); ?></h3>
        <p> <?php _e('Example:', 'cs_ld_addon' ); ?><em> <strong> <?php _e('till', 'cs_ld_addon' ); ?> <?php echo date('F jS, Y g:i A', strtotime('2020-05-01')); ?></strong></em></p>
    <div class="crse-av_shortcode_box">
        <code>[schedule_datetime_end_only]</code>
            <button class="crse-lrn_woo_copy-button">
                <span class="dashicons dashicons-admin-page"></span>
            </button>
        </div>
    </div>

</div>