<?php
/**
 * Abort if this file is accessed directly.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
if ( ( ! class_exists( 'CSLD_Schedular_Pro_ShortCode' ) ) ) {
class CSLD_Schedular_Pro_ShortCode extends LearnDash_Shortcodes_Section {

	function __construct( $fields_args = array() ) {
		$this->fields_args = $fields_args;

		$this->shortcodes_section_key 			= 	'csld_schedule';
		$this->shortcodes_section_title 		= 	esc_html__( 'Schedular Pro', 'cs_ld_addon' );
		$this->shortcodes_section_type			=	1;
		$this->shortcodes_section_description	=	__( "Display ".strtolower( LearnDash_Custom_Label::get_label( 'course' ) ).", ". strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) .", ". strtolower( LearnDash_Custom_Label::get_label( 'quiz' ) ) ." or ".strtolower( LearnDash_Custom_Label::get_label( 'topic' ) )." show/hide dates.", 'cs_ld_addon' );
		
		parent::__construct(); 
	}
	
	function init_shortcodes_section_fields() {
		$this->shortcodes_option_fields = array(
			'object_ids' => array(
				'id'			=>	$this->shortcodes_section_key . '_object_ids',
				'name'  		=> 	'object_ids', 
				'type'  		=> 	'text',
				'label' 		=> 	LearnDash_Custom_Label::get_label( 'course' ) . '/' . LearnDash_Custom_Label::get_label( 'lesson' ) . '/' . LearnDash_Custom_Label::get_label( 'topic' ) . '/' . LearnDash_Custom_Label::get_label( 'quiz' ) . __( ' ID(s)', 'cs_ld_addon' ),
				'help_text'		=>	__( 'A commoa seperated list of ', 'cs_ld_addon' ) . LearnDash_Custom_Label::get_label( 'course' ) . '/' . LearnDash_Custom_Label::get_label( 'lesson' ) . '/' . LearnDash_Custom_Label::get_label( 'topic' ) . '/' . LearnDash_Custom_Label::get_label( 'quiz' ) . __( 'ID(s).', 'cs_ld_addon' ),
				'value' 		=> 	true,
				'class'			=>	'small-text',
			),
		);
	
		$this->shortcodes_option_fields = apply_filters( 'learndash_settings_fields', $this->shortcodes_option_fields, $this->shortcodes_section_key );
		
		parent::init_shortcodes_section_fields();
	}
}
}