(function ($) {
    'use strict';
    $(document).ready(function () {
        /* initialize the calendar
        -----------------------------------------------------------------*/
        var prev_date = '';
        $('#csld-calendar').fullCalendar({
            weekMode: 'variable',
            header: {
                left: 'prev,next today',
                center: 'title',
                right: 'month,basicWeek,basicDay, listWeek'
            },
            editable: true,
            theme: true,
            droppable: false, // this allows things to be dropped onto the calendar
            navLinks: true, // can click day/week names to navigate views
            eventLimit: true, // allow "more" link when too many events
            events: function (start, end, timezone, callback) {
                var moment = $('#csld-calendar').fullCalendar('getDate');
                var currDate = moment.format();
                currDate = currDate.split("-");
                var dashboard_type = $('#csld-dashboard-type').val();
                var user_id = $('#csld-user_id').val();

                jQuery.ajax({
                    type: "post",
                    url: LDCSAdminVars.ajax_url,
                    data: { action: "getUserEvents", month: currDate[1], year: currDate[0], user_id: user_id },
                    success: function (response) {


                        var events = [];
                        events = response;
                        $('.fu_popover_Theme_red').hide();
                        callback(events);
                    }
                });
            },
            eventRender: function (event, element) {

                $('.fu_popover_Theme_red').hide();

                //Initializing Start Date
                var start_date = '';
                var start_date_formatted = '';
                if (event.hasOwnProperty('start')) {
                    start_date = event.start.format();
                    start_date_formatted = new Date(start_date).toUTCString();
                }

                //Initializing End Date
                var end_date = '';
                var end_date_formatted = '';
                if (event.hasOwnProperty('end')) {
                    if (event.end != null) {
                        end_date = event.end.format();
                        end_date_formatted = new Date(end_date).toUTCString();
                    }
                    else {
                        end_date_formatted = '';
                    }
                }

                //Remove object types from title
                if (event.object_type === "sfwd-courses") {
                    var title = event.title.replace('Course:', '');
                }
                if (event.object_type === "sfwd-lessons") {
                    var title = event.title.replace('Lesson:', '');
                }
                if (event.object_type === "sfwd-quiz") {
                    var title = event.title.replace('Quiz:', '');
                }
                if (event.object_type === "sfwd-topic") {
                    var title = event.title.replace('Topic:', '');
                }


                var tooltip_txt = '<strong>Start Date: </strong>' + start_date_formatted + ' <br/> <strong>End Date: </strong>' + end_date_formatted; //Preparing tooltip text

                element.fu_popover({
                    content: tooltip_txt,
                    placement: 'top',
                    title: event.title,
                    trigger: 'hover',
                    themeName: 'Theme_red',
                    width: '270px'
                });

                element.find('.fc-content').find('.fc-time').text(''); //Removing '12a' text from element


            },
            eventDragStart: function (event) {

            },

            eventDrop: function (event, delta, revertFunc) {

            },
            drop: function (date) {

            }
        });

    });



})(jQuery);
