<?php
/**
 * Abort if this file is accessed directly.
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if( is_admin() ) {
    $show_courses_message_option = html_entity_decode( get_option( 'cs_ld_addon_show_course_message' ) );
    $hide_courses_message_option = html_entity_decode( get_option( 'cs_ld_addon_hide_course_message' ) );
    $hide_for_all_course_message = html_entity_decode( get_option( 'cs_ld_addon_hide_for_all_course_message' ) );
    $parent_hide_courses_message = html_entity_decode( get_option( 'cs_ld_addon_parent_hide_courses_message' ) );
} else {
    $user_id = get_current_user_id();

    $hide_for_all_course_message = html_entity_decode( get_user_meta( $user_id, 'cs_ld_addon_hide_for_all_course_message', true ) );
    if( empty( $hide_for_all_course_message ) ) {
        $hide_for_all_course_message = html_entity_decode( get_option( 'cs_ld_addon_hide_for_all_course_message' ) );
    }

    $show_courses_message_option = html_entity_decode( get_user_meta( $user_id, 'cs_ld_addon_show_course_message', true ) );
    if( empty( $show_courses_message_option ) ) {
        $show_courses_message_option = html_entity_decode( get_option( 'cs_ld_addon_show_course_message' ) );
    }

    $hide_courses_message_option = html_entity_decode( get_user_meta( $user_id, 'cs_ld_addon_hide_course_message', true ) );
    if( empty( $hide_courses_message_option ) ) {
        $hide_courses_message_option = html_entity_decode( get_option( 'hide_courses_message_option' ) );
    }

    $parent_hide_courses_message = html_entity_decode( get_user_meta( $user_id, 'cs_ld_addon_parent_hide_courses_message', true ) );
    if( empty( $parent_hide_courses_message ) ) {
        $parent_hide_courses_message = html_entity_decode( get_option( 'parent_hide_courses_message' ) );
    }
}

$show_courses_message = !empty( $show_courses_message_option ) ? $show_courses_message_option : __('The ' . strtolower( LearnDash_Custom_Label::get_label( 'course' ) ) . ' will be available on below date/s: [cs_scheduled_dates]', 'cs_ld_addon');
$hide_courses_message = !empty( $hide_courses_message_option ) ? $hide_courses_message_option : __('The '. strtolower( LearnDash_Custom_Label::get_label( 'course' ) ) .' will not be available on below date/s: [cs_scheduled_dates]', 'cs_ld_addon');
$parent_hide_courses_message = !empty( $parent_hide_courses_message ) ? $parent_hide_courses_message : __('You are unable to view this content because its parent '. strtolower( LearnDash_Custom_Label::get_label( 'course' ) ) .' is hidden.', 'cs_ld_addon');
$hide_for_all_course_message = !empty( $hide_for_all_course_message ) ? $hide_for_all_course_message : __('You are not allowed to view this content.', 'cs_ld_addon');        
?>
<div id="course_settings" class="cs_ld_tabs ARwebcrafts_addon_plnr-crse">
<div class="ldcpp-loader-ovrly-pnl">
	<div class="ldcpp-loader-ovrly"></div>
</div>
    <form method="post">
        <table class="setting-table-wrapper">
            <tbody>
                <tr> 
                    <td class="qst-mrk-tbla-crse-plnr">
                        <label for="maintenance_mode_level_off">
                            <?php echo __( 'Message when "Show ', 'css_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'courses' ) ) . '/' . strtolower( LearnDash_Custom_Label::get_label( 'lessons' ) ) . '/' . strtolower( LearnDash_Custom_Label::get_label( 'topics' ) ) . '/' . strtolower( LearnDash_Custom_Label::get_label( 'quizzes' ) ) . __( ' on specified dates" setting is enabled.', 'cs_ld_addon'); ?>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description" style="font-weight: normal;">
                            <?php echo __('This message will be shown when a user visits ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'course' ) ) . __( ' page and that course has been scheduled for a later date (with the first setting option being selected in the general settings). You can use <strong>[cs_scheduled_dates], [cs_scheduled_dates_start_only] and [cs_scheduled_dates_end_only]</strong> to get the scheduled dates.', 'cs_ld_addon'); ?>
                        </p>
                    </td>
                    <td>
                        <?php wp_editor( $show_courses_message, 'show_courses_message', array('media_buttons' => false,'textarea_rows' => 5) ); ?>
                    </td>

                </tr>
                <tr>

                    <td class="qst-mrk-tbla-crse-plnr">
                        <label for="maintenance_mode_level_off">
                            <?php echo __( 'Message when "Hide ', 'css_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'courses' ) ) . '/' . strtolower( LearnDash_Custom_Label::get_label( 'lessons' ) ) . '/' . strtolower( LearnDash_Custom_Label::get_label( 'topics' ) ) . '/' . strtolower( LearnDash_Custom_Label::get_label( 'quizzes' ) ) . __( ' on specified dates" setting is enabled.', 'cs_ld_addon'); ?>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description" style="font-weight: normal;">
                            <?php echo __('This message will be shown when a user visits ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'courses' ) ) . __( ' page and that course has been scheduled for dates except the ones set on the calendar (with the second setting option being selected in the general settings). You can use <strong>[cs_scheduled_dates], [cs_scheduled_dates_start_only] and [cs_scheduled_dates_end_only]</strong> to get the scheduled dates.', 'cs_ld_addon'); ?>
                        </p>
                    </td>
                    <td>
                        <?php wp_editor( $hide_courses_message , 'hide_courses_message', array('media_buttons' => false,'textarea_rows' => 5) ); ?>
                    </td>
                </tr>
                <tr>

                    <td class="qst-mrk-tbla-crse-plnr">
                        <label for="maintenance_mode_level_off">
                            <?php _e('Message when "Hidden for All Users" meta setting is enabled.', 'cs_ld_addon'); ?>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description" style="font-weight: normal;">
                            <?php echo __('This message will be shown when a user is not configured to visit a ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'course' ) ) . __( ' page due to "Hidden for All Users" meta setting.', 'cs_ld_addon'); ?>
                        </p>
                    </td>
                    <td>
                        <?php wp_editor( $hide_for_all_course_message , 'hide_for_all_course_message', array('media_buttons' => false,'textarea_rows' => 5) ); ?>
                    </td>
                </tr>
                <tr>
                    
                    <td class="qst-mrk-tbla-crse-plnr">
                                            <label for="maintenance_mode_level_off">
                            <?php echo __('Message when "', 'cs_ld_addon' ). LearnDash_Custom_Label::get_label( 'lesson' ) . __( ' parent ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'course' ) ) . __(' is hidden" setting is enabled.', 'cs_ld_addon'); ?>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description" style="font-weight: normal;">
                            <?php echo __('This message will be shown when the ', 'cs_ld_addon') . LearnDash_Custom_Label::get_label( 'lesson' ) . __( ' parent ', 'cs_ld_addon' ) .strtolower( LearnDash_Custom_Label::get_label( 'course' ) ). __( ' is hidden.', 'cs_ld_addon'); ?>
                        </p>
                    </td>
                    <td>
                        <?php wp_editor( $parent_hide_courses_message , 'parent_hide_courses_message', array('media_buttons' => false,'textarea_rows' => 5) ); ?>
                    </td>
                </tr>
            </tbody>
        </table>
        <div class="submit-button">
            <input type="submit" name="save_csld_course_settings" class="button-primary cs-ld-addon-btn" value="<?php _e('Update Settings', 'cs_ld_addon'); ?>" >
        </div>
        <?php wp_nonce_field( 'csld_course_settings', 'csld_course_settings_field' ); ?>
    </form>
</div>