<?php
/**
 * Abort if this file is accessed directly.
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
class CS_LD_METABOXES {
    public function __construct() {

        add_action( 'add_meta_boxes', array( $this, 'cs_ld_register_meta_boxes') );
        add_action( 'save_post', [$this,'cs_ld_save_meta_box'] );
    }
    
    /**
	 * Save meta box content.
	 *
	 * @param int $post_id Post ID
	 */
	function cs_ld_save_meta_box( $post_id ) {
		
		$post_tvp = get_post_type( $post_id );
		if( trim( $post_tvp ) == 'sfwd-courses' ||  trim( $post_tvp ) == 'sfwd-lessons' ||  trim( $post_tvp ) == 'sfwd-quiz' ||  trim( $post_tvp ) == 'sfwd-topic' ) {
			
			$show_hide_action = sanitize_text_field( $_POST['show_hide_action'] );
			update_post_meta( $post_id, '_show_hide_action', $show_hide_action );

			$csld_hide_all_users = sanitize_text_field( $_POST['csld_hide_all_users'] );
			update_post_meta( $post_id, '_csld_hide_all_users', $csld_hide_all_users );
		}
	}
    /**
	 * Register Meta Box
	 */
	function cs_ld_register_meta_boxes() {
		add_meta_box( 'cs-ld-course-meta-box', esc_html__( 'Show/Hide Date', 'cs_ld_addon' ), [$this,'cs_ls_define_show_hide'], 'sfwd-courses', 'side', 'high' );
		add_meta_box( 'cs-ld-lesson-meta-box', esc_html__( 'Show/Hide Date', 'cs_ld_addon' ), [$this,'cs_ls_define_show_hide'], 'sfwd-lessons', 'side', 'high' );
		add_meta_box( 'cs-ld-quizzes-meta-box', esc_html__( 'Show/Hide Date', 'cs_ld_addon' ), [$this,'cs_ls_define_show_hide'], 'sfwd-quiz', 'side', 'high' );
		add_meta_box( 'cs-ld-topic-meta-box', esc_html__( 'Show/Hide Date', 'cs_ld_addon' ), [$this,'cs_ls_define_show_hide'], 'sfwd-topic', 'side', 'high' );
    }
    
    /**
	 * show form on product post
	 */
	function cs_ls_define_show_hide( $meta_id ) {
			
		$prefix = '_cs_ls_';
		$post_id = isset( $_GET['post'] ) ? $_GET['post'] : 0;
		$show_hide_action = get_post_meta( $post_id, '_show_hide_action', true );
		$csld_hide_all_users = get_post_meta( $post_id, '_csld_hide_all_users', true );
		echo '<table width="100%">';
		echo '<tr><td><input type="checkbox" name="csld_hide_all_users" id="csld_hide_all_users" '.($csld_hide_all_users=='yes'?'checked':'').' value="yes"/>&nbsp;'.__('Hidden for All Users', 'cs_ld_addon').'</td></tr>';
		echo '<tr><td>'.__( 'Show/Hide', 'cs_ld_addon' ).'</td></tr>';
		echo '<tr><td><select id="cs-ld-action" name="show_hide_action"><option value="" selected >'.__( 'Select Action', 'cs_ld_addon' ).'</option><option value="show" '.($show_hide_action=='show'?'selected':'').'>'.__( 'Show', 'cs_ld_addon' ).'</option><option value="hide" '.($show_hide_action=='hide'?'selected':'').'>'.__( 'Hide', 'cs_ld_addon' ).'</option></select></td></tr>';
		echo '<tr><td><b>'.__( 'Show:', 'cs_ld_addon' ).'</b> '.__( 'show "only" on selected dates.', 'cs_ld_addon' ).'</td></tr>';
		echo '<tr><td><b>'.__( 'Hide:', 'cs_ld_addon' ).'</b> '.__( 'Hide "only" on selected dates.', 'cs_ld_addon' ).'</td></tr>';
		echo '</table>';
	}
}
new CS_LD_METABOXES();