<?php

/**
 * License Class.
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class LCMS_License {
    private $license_key_field = null;

    /**
     * @var LCMS_License_Handler
     */
    private $license_handler = null;

    public function __construct() {

        $this->license_key_field = 'wn_lcms_license_key';

        add_action( 'init', [ $this, 'plugin_init' ] );
        add_action( 'admin_notices', [ $this, 'show_license_expire_or_invalid' ], 20 );

        /**
         * Enable these for local testing
         */
         # add_filter( 'edd_sl_api_request_verify_ssl', '__return_false', 10, 2 );
         # add_filter( 'https_ssl_verify', '__return_false' );
         # add_filter( 'http_request_host_is_external', '__return_true', 10, 3 );
         
    }

    public function plugin_init() {
        
        if ( ! current_user_can( 'manage_options' ) || ! is_admin() )
            return;
        $plugin_data = get_plugin_data( CSLDP_DIR_FILE, true , false );
        $this->license_handler = new LCMS_License_Handler( CSLDP_DIR_FILE, $plugin_data['Name'], $plugin_data['Version'], $plugin_data['AuthorName'], $this->license_key_field );
    }

    public function show_license_expire_or_invalid() {
        if ( ! isset( $this->license_handler ) )
            return;

        $license_setting_url = add_query_arg( array( 'page' => 'calendar_course_settings', 'tab' => 'license' ), admin_url( 'admin.php' ) );
        $error_msg = '';
        $success_msg = '';
        $submission = isset( $_POST['lcms_activate_license'] ) || isset( $_POST['lcms_deactivate_license'] );

        $product_link = 'https://www.arwebcrafts.com/downloads/learndash-course-management-system/';
        $invalid_license_err = sprintf(__( 'Please enter a valid license key for <strong>%s</strong> <a href="%s">here</a> to receive latest updates.', 'cs_ld_addon' ), esc_attr('LearnDash Course Planner Pro'), esc_attr($license_setting_url));
	    $expired_license_err = sprintf(__( 'Your license for <strong>%s</strong> has been expired. Please click <a href="%s" target="_blank">here</a> to renew your license and receive latest updates.', 'cs_ld_addon' ), esc_attr('LearnDash Course Planner Pro'), esc_attr($product_link));

        if( $submission ) {
            if( $this->license_handler->is_active() ) {
                $success_msg = __( 'License Activated!', 'cs_ld_addon' );
            } else if( $this->license_handler->is_expired() ) {
                $error_msg = $expired_license_err;
            } else if( $this->license_handler->last_err() ) {
                $error_msg = $invalid_license_err;
            } else if( !$this->license_handler->is_active() ) {
                $success_msg = __( 'License Deactivated!', 'cs_ld_addon' );
            }
        } else {
            if ( $this->license_handler->is_expired() ) {
                $error_msg = $expired_license_err;
            } else if( !$this->license_handler->is_active() ) {
                $error_msg = $invalid_license_err;
            }
        }

        if( $success_msg ) { ?>
            <div class="notice notice-success is-dismissible">
                <p><?php echo $success_msg; ?></p>
            </div>
            <?php
        } else if( $error_msg ) { ?>
            <div class="notice notice-error is-dismissible">
                <p><?php echo $error_msg; ?></p>
            </div>
            <?php
        }
    }

	/**
	 * @return LCMS_License_Handler
	 */
    public function get_license_handler() {
        return $this->license_handler;
    }

	/**
	 * @return string
	 */
	public function get_license_key_field() {
		return $this->license_key_field;
	}
}
