<?php
/**
 * Abort if this file is accessed directly.
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
  
if( is_admin() ) {
    $show_lesson_message_option = html_entity_decode( get_option( 'cs_ld_addon_show_lesson_message' ) );
    $hide_lesson_message_option = html_entity_decode( get_option( 'cs_ld_addon_hide_lesson_message' ) );
    $hide_for_all_lesson_message = html_entity_decode( get_option( 'cs_ld_addon_hide_for_all_lesson_message' ) );
    $parent_hide_lesson_message = html_entity_decode( get_option( 'cs_ld_addon_parent_hide_lesson_message' ) );
} else {
    $user_id = get_current_user_id();
    
    $hide_for_all_lesson_message = html_entity_decode( get_user_meta( $user_id, 'cs_ld_addon_hide_for_all_lesson_message', true ) );
    if( empty( $hide_for_all_lesson_message ) ) {
        $hide_for_all_lesson_message = html_entity_decode( get_option( 'cs_ld_addon_hide_for_all_lesson_message' ) );
    }

    $show_lesson_message_option = html_entity_decode( get_user_meta( $user_id, 'cs_ld_addon_show_lesson_message', true ) );
    if( empty( $show_lesson_message_option ) ) {
        $show_lesson_message_option = html_entity_decode( get_option( 'cs_ld_addon_show_lesson_message' ) );
    }

    $hide_lesson_message_option = html_entity_decode( get_user_meta( $user_id, 'cs_ld_addon_hide_lesson_message', true ) );
    if( empty( $hide_lesson_message_option ) ) {
        $hide_lesson_message_option = html_entity_decode( get_option( 'cs_ld_addon_hide_lesson_message' ) );
    }

    $parent_hide_lesson_message = html_entity_decode( get_user_meta( $user_id, 'cs_ld_addon_parent_hide_lesson_message', true ) );
    if( empty( $parent_hide_lesson_message ) ) {
        $parent_hide_lesson_message = html_entity_decode( get_option( 'cs_ld_addon_parent_hide_lesson_message' ) );
    }
}
$show_lesson_message = !empty( $show_lesson_message_option ) ? $show_lesson_message_option : 'The ' . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . ' will be available on below date/s: [cs_scheduled_dates]' ;
$hide_lesson_message = !empty( $hide_lesson_message_option ) ? $hide_lesson_message_option : 'The ' . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . ' will not be available on below date/s: [cs_scheduled_dates]' ;
$parent_hide_lesson_message = !empty( $parent_hide_lesson_message ) ? $parent_hide_lesson_message : 'You are unable to view this content because its parent '. strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) .' is hidden.' ;
$hide_for_all_lesson_message = !empty( $hide_for_all_lesson_message ) ? $hide_for_all_lesson_message : __('You are not allowed to view this content.', 'cs_ld_addon');        
?>
<div id="lesson_settings" class="cs_ld_tabs ARwebcrafts_addon_plnr-crse">
<div class="ldcpp-loader-ovrly-pnl">
	<div class="ldcpp-loader-ovrly"></div>
</div>
    <form method="post" action="">
        <table class="setting-table-wrapper">
            <tbody>
                <tr>
                    <td class="qst-mrk-tbla-crse-plnr">
                        <label for="maintenance_mode_level_off">
                            <?php echo __('Message when "Show ', 'css_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'courses' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'topics' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'quizzes' ) ) . __( ' on specified dates" setting is enabled.', 'cs_ld_addon'); ?>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description">
                            <?php echo __('This message will be shown when a user visits ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . __( ' page and that ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . __( ' has been scheduled for a later date (with the first setting option being selected in the general settings). You can use <strong>[cs_scheduled_dates], [cs_scheduled_dates_start_only] and [cs_scheduled_dates_end_only]</strong> to get the scheduled dates.', 'cs_ld_addon'); ?>
                        </p>
                    </td>
                    <td>
                        <?php wp_editor( $show_lesson_message, 'show_lesson_message', array('media_buttons' => false,'textarea_rows' => 5) ); ?>
                    </td>

                </tr>
                <tr>

                    <td class="qst-mrk-tbla-crse-plnr">
                        <label for="maintenance_mode_level_off">
                            <strong><?php echo __( 'Message when "Hide ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'courses' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'topics' ) ) . ', ' . strtolower( LearnDash_Custom_Label::get_label( 'quizzes' ) ) . __( ' on the specified dates" setting enabled', 'cs_ld_addon'); ?></strong>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description">
                            <?php echo __('This message will be shown when a user ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . __( ' page and that ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . __( ' has been scheduled for dates except the ones set on the calendar (with the second setting option being selected in the general settings). You can use <strong>[cs_scheduled_dates], [cs_scheduled_dates_start_only] and [cs_scheduled_dates_end_only]</strong> to get the scheduled dates.', 'cs_ld_addon'); ?>
                        </p>
                    </td>
                    <td>
                        <?php wp_editor( $hide_lesson_message, 'hide_lesson_message', array('media_buttons' => false,'textarea_rows' => 5) ); ?>
                    </td>
                </tr>
                
                <tr>

                    <td class="qst-mrk-tbla-crse-plnr">
                        <label for="maintenance_mode_level_off">
                            <?php _e('Message when "Hidden for All Users" meta setting is enabled.', 'cs_ld_addon'); ?>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description">
                            <?php echo __('This message will be shown when a user is not configured to a ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . __( ' page due to "Hidden for All Users" meta setting.', 'cs_ld_addon'); ?>
                        </p>
                    </td>
                    <td>
                        <?php wp_editor( $hide_for_all_lesson_message , 'hide_for_all_lesson_message', array('media_buttons' => false,'textarea_rows' => 5) ); ?>
                    </td>
                </tr>
                <tr>
                    <td class="qst-mrk-tbla-crse-plnr">
                        <label for="maintenance_mode_level_off">
                            <?php echo __( 'Message when "', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'quiz' ) ) . __( ' or ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'topic' ) ) . __( ' parent ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . __( ' is hidden" setting is enabled.', 'cs_ld_addon'); ?>
                            <i class="fas fa-question"></i>
                        </label>
                        <p class="description">
                            <?php echo __('This message will be shown when the ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'quiz' ) ) .  __( ' or ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'topic' ) ) . __( ' parent ', 'cs_ld_addon' ) . strtolower( LearnDash_Custom_Label::get_label( 'lesson' ) ) . __( ' is hidden.', 'cs_ld_addon'); ?>
                        </p>
                    </td>
                    <td>
                        <?php wp_editor( $parent_hide_lesson_message, 'parent_hide_lesson_message', array('media_buttons' => false,'textarea_rows' => 5) ); ?>
                    </td>
                </tr>

            </tbody>
        </table>
        <div class="submit-button">
            <input type="submit" name="save_csld_lesson_settings" class="cs-ld-addon-btn" value="<?php _e('Update Settings', 'cs_ld_addon'); ?>" >
        </div>
        <?php wp_nonce_field( 'csld_lesson_settings', 'csld_lesson_settings_field' ); ?>
    </form>
</div>