<?php
if(!class_exists('LD_CMS_HELPER')) {
	class LD_CMS_HELPER {

		
		public static function register_calendar_scripts($version) {
			wp_register_style( 'jquery-ui', 'https://code.jquery.com/ui/1.12.1/themes/smoothness/jquery-ui.css', array(), $version );
			// wp_enqueue_style('ld-cms-ui-css','https://code.jquery.com/ui/1.10.4/themes/ui-lightness/jquery-ui.css',false,"1.9.0",false);
			wp_register_style( 'ld-cms-ui-js', "https://code.jquery.com/ui/1.10.4/jquery-ui.js", array( 'jquery' ), time(), true);

			wp_register_script( 'fullcalendar', 'https://cdn.jsdelivr.net/npm/fullcalendar@5.5.1/main.min.js', array( 'moment' ), $version, true );
			wp_register_style( 'fullcalendar', 'https://cdn.jsdelivr.net/npm/fullcalendar@5.5.1/main.min.css', array(), $version );
			wp_register_script( 'ld-cms-select2', CS_LD_PLUGIN_URL . 'assets/js/select2/select2.min.js', array( 'jquery' ), $version, true );
			wp_register_style( 'ld-cms-select2', CS_LD_PLUGIN_URL . 'assets/js/select2/select2.css', array(), $version );
			wp_register_style( 'ld-cms-thickbox', CS_LD_PLUGIN_URL . 'assets/css/ld-cms-thickbox.css', array(), $version );
			wp_register_script( 'ld-cms-calendar', CS_LD_PLUGIN_URL . 'assets/js/ld_cms_calendar.js', array( 'fullcalendar', 'jquery-ui-tabs', 'jquery-ui-draggable', 'jquery-ui-droppable', 'thickbox', 'jquery-ui-datepicker', 'ld-cms-select2' ), time(), true );
			wp_register_style( 'ld-cms-calendar', CS_LD_PLUGIN_URL . 'assets/css/ld-cms-calendar.css', array(), $version );
			wp_register_script( 'popperjs', 'https://unpkg.com/@popperjs/core@2', array( 'jquery' ), $version, true );
			wp_register_script( 'tippyjs', 'https://unpkg.com/tippy.js@6', array( 'jquery' ), $version, true );
			wp_register_script( 'jquery_timepicker', '//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.js', array( 'jquery' ), $version, true );
			wp_register_style( 'jquery_timepicker', '//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css', array(), $version );
			wp_register_style( 'fontawesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.13.1/css/all.min.css', array(), $version );
			wp_register_script( 'moment', 'https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', array( 'jquery' ), $version, true );
			wp_register_script( 'ld-cms-moment-timezone', 'https://cdnjs.cloudflare.com/ajax/libs/moment-timezone/0.5.34/moment-timezone.min.js', array( 'jquery' ), $version, true );
			wp_register_style( 'ld-cms-admin-style', CS_LD_PLUGIN_URL . 'assets/css/admin.css', array(), $version );
			wp_register_script( 'ld-cms-admin-script', CS_LD_PLUGIN_URL . 'assets/js/admin.js', array('jquery'), time(), true  ); 

			wp_register_script( 'ld-cms-admin-upgrade-db', CS_LD_PLUGIN_URL . 'assets/js/lcms_upgrade_db.js', array('jquery'), time(), true  );
			
		}

		public static function enqueue_calendar_scripts() {
			wp_enqueue_script( 'ld-cms-admin-upgrade-db' );
			wp_enqueue_style( 'ld-cms-admin-style' );
			wp_enqueue_style( 'fullcalendar' );
			wp_enqueue_script( 'fullcalendar');
			wp_enqueue_style( 'ld-cms-thickbox');
			wp_enqueue_script( 'ld-cms-select2'); 
			wp_enqueue_style( 'ld-cms-select2');
				
			//Thickbox assets
			wp_enqueue_script('ld-cms-admin-script');
			wp_enqueue_script('thickbox');
			wp_enqueue_style('thickbox');
			wp_enqueue_script('jquery-ui-datepicker');
			wp_enqueue_style( 'jquery-ui');
			wp_enqueue_style( 'fontawesome');
			wp_enqueue_script( 'moment');
			wp_enqueue_script( 'ld-cms-moment-timezone');
			wp_enqueue_script( 'jquery_timepicker');
			wp_enqueue_style( 'jquery_timepicker');
			
			wp_enqueue_script( 'popperjs');
			wp_enqueue_script( 'tippyjs');
			wp_enqueue_script( 'ld-cms-calendar');
			wp_enqueue_style( 'ld-cms-calendar');

			$js_vars = array();
			$js_vars[ 'ajax_url' ] = admin_url( 'admin-ajax.php' );
			$js_vars[ 'preloader' ] = CS_LD_PLUGIN_URL.'/assets/css/images/ajax-loader.gif';
			$js_vars[ 'include_user_role' ] = __( 'Include User Role', 'cs_ld_addon' );
			$js_vars[ 'include_users' ] = __( 'Include Users', 'cs_ld_addon' );
			$js_vars[ 'exclude_user_role' ] = __( 'Exclude User Role', 'cs_ld_addon' );
			$js_vars[ 'exclude_users' ] = __( 'Exclude Users', 'cs_ld_addon' );
			$js_vars[ 'are_u_sure_to_delete' ] = __( 'Are you sure you want to delete?', 'cs_ld_addon' );
			$js_vars[ 'are_u_sure_about_change' ] = __( 'Are you sure about this change?', 'cs_ld_addon' );
			$js_vars[ 'searching' ] = __( 'Searching....', 'cs_ld_addon' );
			$js_vars[ 'no_results' ] = __( 'No Results', 'cs_ld_addon' );
			$js_vars[ 'check_nonce' ] = wp_create_nonce('ld-cms-nonce');
			$js_vars[ 'current_user_id' ] = is_user_logged_in() ? get_current_user_id() : 0;
 
			$js_vars[ 'start_calendar' ] = current_time('Y-m-d');
			$js_vars['now_calendar_time'] =  current_time('Y-m-d H:i:s');
			
			$js_vars[ 'end_calendar' ] = date('Y-m-d' , strtotime("+2 Year", strtotime(current_time('Y-m-d'))) );

			$show_options = get_option( 'course_scheduler_ld_addon_setting' );
			$js_vars[ 'show_options' ] = ! empty( $show_options ) ? $show_options : 'show' ;

			$js_vars[ 'ld_cms_group_roles_schedule' ] = get_option( 'ld_cms_group_roles_schedule', []);
			$lang = get_locale();
			if ( strlen( $lang ) > 0 ) {
				$lang = explode( '_', $lang )[0];
				$js_vars[ 'lang' ] = ! empty( $lang ) ? $lang : 'en' ;
			}
			wp_localize_script( 'ld-cms-calendar', 'LDCSAdminVars', $js_vars );
		}

		public static function is_course_admin( $post_id, $user_id = 0 ) {
			$course_id = learndash_get_course_id($post_id);

			if(empty($user_id)) {
				$user_id = get_current_user_id();
			}
			$is_user_allowed = false;
			//$is_user_allowed = learndash_is_admin_user(); 
			$check_edit = CS_LD_TREE_HELPER::check_event_edit($post_id, $course_id, $user_id);
			if ( $check_edit ) {
				$is_user_allowed=true;
				// $course_group_ids       = learndash_get_course_groups( $course_id );
				// $group_leader_group_ids = learndash_get_administrators_group_ids( $user_id );
				// $groups_ids_intersect   = array_intersect( $course_group_ids, $group_leader_group_ids );
				// $is_user_allowed        = ! empty( $groups_ids_intersect );
			}

			// if ( !$is_user_allowed && learndash_is_group_leader_user($user_id) && $post_id==0) {
			// 	$is_user_allowed=true;
			// }



			return $is_user_allowed;
		}
	}
}