<?php
/**
 * Plugin Name: LearnDash Course Planner Pro
 * Plugin URI: https://www.arwebcrafts.com/downloads/learndash-course-management-system/
 * Description: Show/Hide LearnDash courses/lessons/topics/quizzes on specific dates easily through interactive calendar drag and drop interface.
 * Version: 1.15.6
 * Requires at least: 5.1
 * Requires PHP: 7.2
 * Author: ARwebcrafts
 * Author URI: https://www.arwebcrafts.com/
 * Text Domain: cs_ld_addon
 * License: GNU General Public License v2.0
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) exit;

register_activation_hook( __FILE__, ['LCMS_Main', 'activation' ] );
register_deactivation_hook( __FILE__, ['LCMS_Main', 'deactivation' ] );

/**
 * Class LDCSP_Main
 */
class LCMS_Main {

	const VERSION = '1.15.6';

	/**
	 * @var self
	 */
	private static $instance = null;

	/**
	 * @since 1.0
	 * @return $this
	 */
	public static function instance() {
		
		if ( is_null( self::$instance ) && ! ( self::$instance instanceof LCMS_Main ) ) {
			self::$instance = new self;

			self::$instance->setup_constants();
			self::$instance->includes();
			self::$instance->hooks();
		}

		return self::$instance;
	}

	/**
	 * Activation function hook
	 *
	 * @since 1.0
	 * @return void
	 */
	public static function activation() {
		
		if ( ! current_user_can( 'activate_plugins' ) )
			return;

		// global $wpdb;
		if(get_option('course_scheduler_ld_addon_setting') === false) {
			update_option( 'course_scheduler_ld_addon_setting', 'show' );
		}
		
		if( get_option('ld_cms_group_roles_schedule') === false ) {
			update_option( 'ld_cms_group_roles_schedule', [ 'group_leader' ] );
		}

		if( get_option('ld_cms_group_selected_roles_manage_their_courses') === false ) {
			update_option( 'ld_cms_group_selected_roles_manage_their_courses', 'yes' );
		}

		if( get_option('ld_cms_schedule_excluded_user_roles') === false ) {
			update_option( 'ld_cms_schedule_excluded_user_roles', [ 'administrator' ] );
		}

		if(get_option('cs_ld_addon_show_course_message') === false) {
			update_option( 'cs_ld_addon_show_course_message', __( 'The ' . LearnDash_Custom_Label::label_to_lower( 'course' ) . ' will be available on below date/s: [cs_scheduled_dates]', 'cs_ld_addon' ) );
		}

		if(get_option('cs_ld_addon_hide_course_message') === false) {
			update_option( 'cs_ld_addon_hide_course_message', __( 'The ' . LearnDash_Custom_Label::label_to_lower( 'course' ) . ' will not be available on below date/s: [cs_scheduled_dates]', 'cs_ld_addon' ) );
		}

		if(get_option('cs_ld_addon_show_lesson_message') === false) {
			update_option( 'cs_ld_addon_show_lesson_message', __( 'The ' . LearnDash_Custom_Label::label_to_lower( 'lesson' ) . ' will be available on below date/s: [cs_scheduled_dates]', 'cs_ld_addon' ) );
		}

		if(get_option('cs_ld_addon_hide_lesson_message') === false) {
			update_option( 'cs_ld_addon_hide_lesson_message', __( 'The ' . LearnDash_Custom_Label::label_to_lower( 'lesson' ) . ' will not be available on below date/s: [cs_scheduled_dates]', 'cs_ld_addon' ) );
		}

		if(get_option('cs_ld_addon_show_quiz_message') === false) {
			update_option( 'cs_ld_addon_show_quiz_message', __( 'The ' . LearnDash_Custom_Label::label_to_lower( 'quiz' ) . ' will be available on below date/s: [cs_scheduled_dates]', 'cs_ld_addon' ) );
		}

		if(get_option('cs_ld_addon_hide_quiz_message') === false) {
			update_option( 'cs_ld_addon_hide_quiz_message', __( 'The ' . LearnDash_Custom_Label::label_to_lower( 'quiz' ) . ' will not be available on below date/s: [cs_scheduled_dates]', 'cs_ld_addon' ) );
		}

		if(get_option('cs_ld_addon_show_topic_message') === false) {
			update_option( 'cs_ld_addon_show_topic_message', __( 'The ' . LearnDash_Custom_Label::label_to_lower( 'topic' ) . ' will be available on below date/s: [cs_scheduled_dates]', 'cs_ld_addon' ) );
		}

		if(get_option('cs_ld_addon_hide_topic_message') === false) {
			update_option( 'cs_ld_addon_hide_topic_message', __( 'The ' . LearnDash_Custom_Label::label_to_lower( 'topic' ) . ' will not be available on below date/s: [cs_scheduled_dates]', 'cs_ld_addon' ) );
		}

		if(get_option('cs_ld_addon_parent_hide_courses_message') === false) {
			update_option( 'cs_ld_addon_parent_hide_courses_message', __( 'You are unable to view this content because its parent ' . LearnDash_Custom_Label::label_to_lower( 'course' ) . ' is hidden.', 'cs_ld_addon' ) );
		}

		if(get_option('cs_ld_addon_parent_hide_lesson_message') === false) {
			update_option( 'cs_ld_addon_parent_hide_lesson_message', __( 'You are unable to view this content because its parent ' . LearnDash_Custom_Label::label_to_lower( 'lesson' ) . ' is hidden.', 'cs_ld_addon' ) );
		}

		if(get_option('cs_ld_addon_hide_for_all_course_message') === false) {
			update_option( 'cs_ld_addon_hide_for_all_course_message', __( 'You are not allowed to view this content.', 'cs_ld_addon' ) );
		}

		if(get_option('cs_ld_addon_hide_for_all_lesson_message') === false) {
			update_option( 'cs_ld_addon_hide_for_all_lesson_message', __( 'You are not allowed to view this content.', 'cs_ld_addon' ) );
		}

		if(get_option('cs_ld_addon_hide_for_all_quiz_message') === false) {
			update_option( 'cs_ld_addon_hide_for_all_quiz_message', __( '<p>You are not allowed to view this content.</p>', 'cs_ld_addon' ) );
		}

		if(get_option('cs_ld_addon_hide_for_all_topic_message') === false) {
			update_option( 'cs_ld_addon_hide_for_all_topic_message', __( 'You are not allowed to view this content.', 'cs_ld_addon' ) );
		}
	}

	/**
	 * Deactivation function hook
	 *
	 * @since 1.0
	 * @return void
	 */
	public static function deactivation() {
		delete_option( 'cs_ld_version' );
		delete_option( 'ld_cms_group_selected_roles_manage_their_courses' );
		delete_option( 'ld_cms_group_roles_schedule' );
		delete_option( 'ld_cms_schedule_excluded_user_roles' );
        delete_option( 'course_scheduler_ld_addon_setting' );
        delete_option( 'cs_ld_addon_show_course_message' );
        delete_option( 'cs_ld_addon_hide_course_message' );
        delete_option( 'cs_ld_addon_show_lesson_message' );
        delete_option( 'cs_ld_addon_hide_lesson_message' );
        delete_option( 'cs_ld_addon_show_topic_message' );
        delete_option( 'cs_ld_addon_hide_topic_message' );
        delete_option( 'cs_ld_addon_show_quiz_message' );
		delete_option( 'cs_ld_addon_hide_quiz_message' );
		delete_option( 'cs_ld_addon_hide_for_all_course_message' );
		delete_option( 'cs_ld_addon_hide_for_all_lesson_message' );
		delete_option( 'cs_ld_addon_hide_for_all_quiz_message' );
		delete_option( 'cs_ld_addon_hide_for_all_topic_message' );
		delete_option( 'cs_ld_addon_parent_hide_courses_message' );
		delete_option( 'cs_ld_addon_parent_hide_lesson_message' );
		delete_option( 'ld_cms_send_availability_email' );
		delete_option( 'ld_cms_availability_email_settings' );

		$timestamp = wp_next_scheduled( 'ld_cms_notify_cron_hook' );
		wp_unschedule_event( $timestamp, 'ld_cms_notify_cron_hook' );
	}

	/**
	 * Upgrade function hook
	 *
	 * @since 1.0
	 * @return void
	 */
	public function upgrade() {
		$installed_version = get_option( 'cs_ld_version', 0 );
		if( empty($installed_version) || 0 == $installed_version ){
			$this->create_db_csld_events_table();
			update_option( 'cs_ld_version', self::VERSION );
		}
		if ( $installed_version != self::VERSION ) {
			$this->update_db_csld_events_table();
			update_option( 'cs_ld_version', self::VERSION );
		}
		
	}

	public function create_db_csld_events_table(){

		global $wpdb;
        $table_name = $wpdb->prefix . 'csld_events';
		//ALTER TABLE `wp_csld_events` CHANGE `is_end_date` `is_end_date` VARCHAR(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT ''; 
		if($wpdb->get_var("show tables like '$table_name'") != $table_name) {
			$sql = "CREATE TABLE " . $table_name . " (
				`id` int(10) NOT NULL AUTO_INCREMENT,
				`object_id` int(10) DEFAULT NULL,
				`object_parent_course` int(10) DEFAULT '0',
  				`object_parent_lesson` int(10) DEFAULT '0',
				`object_type` varchar(20) DEFAULT NULL,
				`is_subsdate_as_startdate` varchar(3) NULL DEFAULT 'No',
				`duration` INT(10) NULL DEFAULT '0',
				`duration_type` ENUM('Day','Month','Year') NULL DEFAULT 'Day',
                `start` timestamp NULL DEFAULT NULL,
                `is_end_date` VARCHAR(20) NULL DEFAULT '',
				`end` timestamp NULL DEFAULT NULL,
				`category` int(10) DEFAULT NULL,
				`tag` int(10) DEFAULT NULL,
				`user_filter_type` ENUM('Include', 'Exclude') NULL DEFAULT 'Include',
				`excluded_role` varchar(50) DEFAULT NULL,
				`excluded_users` varchar(50) DEFAULT NULL,
				`ld_group` int(10) DEFAULT NULL,
				`posted_by` int(10) NULL DEFAULT '0',
				PRIMARY KEY (`id`)
			);";
			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
			dbDelta( $sql );
		}
	}

	public function update_db_csld_events_table(){
		error_log('update_db_csld_events_table');
		global $wpdb;
        $table_name = $wpdb->prefix . 'csld_events';
		/**
		 * check if column 'duration_end_date' not exist in the 'db_prefix_csld_events' table
		 */
		$duration_end_date_column_exists = $wpdb->get_results( "SELECT COLUMN_NAME AS columns FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='".$wpdb->dbname."' AND TABLE_NAME='".$table_name."' AND column_name='duration_end_date' " );
        if ( empty($duration_end_date_column_exists) ) {
			$sql    = "ALTER TABLE ".$table_name." ADD COLUMN `duration_end_date` INT(10) NULL DEFAULT '0' AFTER `end`";
			$wpdb->query( $sql );
		}

		/**
		 * check if column 'duration_end_date' not exist in the 'duration_type_end_date' table
		 */
		$duration_type_end_date_column_exists = $wpdb->get_results( "SELECT COLUMN_NAME AS columns FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='".$wpdb->dbname."' AND TABLE_NAME='".$table_name."' AND column_name='duration_type_end_date' " );
        if ( empty($duration_type_end_date_column_exists) ) {
			$sql    = "ALTER TABLE ".$table_name." ADD COLUMN `duration_type_end_date` ENUM('Day','Month','Year') NULL DEFAULT 'Day' AFTER `duration_end_date`";
			$wpdb->query( $sql );
		}
			
	}


	/**
	 * Setup Constants
	 */
	private function setup_constants() {

		/**
		 * FILE
		 */
		define( 'LD_CPP_FILE', __FILE__ );
		/**
		 * Directory
		 */
		define( 'CSLDP_DIR', plugin_dir_path( __FILE__ ) );
		define( 'CSLDP_DIR_FILE', CSLDP_DIR . basename( __FILE__ ) );
		define( 'CSLDP_INCLUDES_DIR', trailingslashit( CSLDP_DIR . 'includes' ) );
		define( 'CSLDP_BASE_DIR', plugin_basename( __FILE__ ) );
		
		/**
		 * URLS
		 */
		define( 'CS_LD_PLUGIN_URL', trailingslashit( plugins_url( '', __FILE__ ) ) );
		define( 'CSLDP_ASSETS_URL', trailingslashit( CS_LD_PLUGIN_URL . 'assets' ) );
	}

	/**
	 * Include Required Files
	 */
	public function includes() {
		require_once( CSLDP_INCLUDES_DIR . 'class-ld-cms-helper.php' );
		if ( file_exists( CSLDP_INCLUDES_DIR . 'CS_LD_HELPER.php' ) ) {
			require_once( CSLDP_INCLUDES_DIR . 'CS_LD_HELPER.php' );
		}

		if ( file_exists( CSLDP_INCLUDES_DIR . 'CS_LD_TREE_HELPER.php' ) ) {
			require_once( CSLDP_INCLUDES_DIR . 'CS_LD_TREE_HELPER.php' );
		}

		if ( file_exists( CSLDP_INCLUDES_DIR . 'CS_LD_METABOXES.php' ) ) {
			require_once( CSLDP_INCLUDES_DIR . 'CS_LD_METABOXES.php' );
		}

		if ( file_exists( CSLDP_DIR . 'license/LCMS_License_Handler.php' ) ) {
			require_once( CSLDP_DIR . 'license/LCMS_License_Handler.php' );
		}

        require_once( CSLDP_INCLUDES_DIR . 'CS_LD_Widget.php' );
		require_once( CSLDP_INCLUDES_DIR . 'LD_CS_NOTIFY.php' );
	}

	public function hooks() {

		add_action( 'admin_enqueue_scripts', [ $this, 'admin_enqueue_scripts' ] );
		add_action( 'wp_enqueue_scripts', [ $this, 'frontend_scripts' ] );
		// add_action( 'plugins_loaded', [ $this, 'upgrade' ] );
		add_action( 'admin_notices', [ $this, 'ld_cms_require_dependency' ] );
		add_action( 'admin_notices', [ $this, 'lcms_update_table_script' ] );
		add_action( 'wp_ajax_lcms_upgrade_db_script', [ $this, 'lcms_sql_upgrade' ] );
		add_action( 'lcms_cron_upgrade_db', [ $this, 'cron_lcms_upgrade_db_script' ] );
		add_action( 'init', [ $this, 'register_calendar_scripts' ] );
		add_action( 'init', [ $this, 'cron_lcms_upgrade_db_script' ] );
		load_plugin_textdomain( 'cs_ld_addon', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
		
		$this->upgrade();
	}

	public function register_calendar_scripts() {
		LD_CMS_HELPER::register_calendar_scripts(self::VERSION);
	}

	/**
     * Enqueue scripts for plugin
     */
    public function frontend_scripts() {
		//jQuery UI date picker file
		wp_enqueue_script('jquery-ui-datepicker');
		//jQuery UI theme css file
		
	    wp_enqueue_style( 'csld_plugin_style_css', CS_LD_PLUGIN_URL . '/assets/css/front.css', array(), time() );
    }
	
	/**
	 * Enqueue scripts on admin
	 *
	 * @param string $hook
	 * @since 1.0
	 */
	public function admin_enqueue_scripts() {
		$page_slug = isset($_GET['page']) ? trim($_GET['page']) : '';
		
		if( !in_array( $page_slug, ['calendar_course', 'calendar_course_settings', 'calendar_import_events'] ) ) {
			return;
		}
		
		LD_CMS_HELPER::enqueue_calendar_scripts();
	}

	function ld_cms_require_dependency() {

		if ( ! class_exists( 'SFWD_LMS' ) ) {
			deactivate_plugins( plugin_basename( __FILE__ ), true );
			unset($_GET['activate']);

			$class = 'notice notice-error is-dismissible';
			$message = sprintf( __(
				'<strong>%s</strong> requires <a href="%s" target="_blank">%s</a> plugin to be active.', 'cs_ld_addon' ),
				esc_attr('LearnDash Course Planner Pro'),
				esc_url('https://www.learndash.com'),
				esc_attr('LearnDash LMS')
			);

			printf ( "<div id='message' class='%s'> <p>%s</p></div>", $class, $message );
		}
	}

	/**
	 * Display admin notifications that dependency not found.
	 */
	public function lcms_incomplete_db() {
		global $wpdb;
		$flag = true;		
		$table_name = $wpdb->prefix . 'csld_events';
		$old_start_date = true;
		$is_end_date_col_exists = $wpdb->get_results("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='is_end_date' and TABLE_NAME='".$table_name."'");
		if( count($is_end_date_col_exists) > 0 ) {
			$data_type = $is_end_date_col_exists[0]->DATA_TYPE;
			if( strtolower($data_type) != 'varchar' ) {
				$old_start_date = false;
			}
		}
		
		$course_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='object_parent_course' and TABLE_NAME='".$table_name."'");
		$lesson_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='object_parent_lesson' and TABLE_NAME='".$table_name."'");
		
		$ufilter_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='user_filter_type' and TABLE_NAME='".$table_name."'");
		
		$is_subsdate_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='is_subsdate_as_startdate' and TABLE_NAME='".$table_name."'");
		
		$duration_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='duration' and TABLE_NAME='".$table_name."'");
		
		$duration_type_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='duration_type' and TABLE_NAME='".$table_name."'");
		
		$posted_by_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='posted_by' and TABLE_NAME='".$table_name."'");

		if( $old_start_date && count( $posted_by_col_exists ) > 0 && count( $is_subsdate_col_exists ) > 0 &&  count( $duration_col_exists ) > 0 && count( $duration_type_col_exists ) > 0 && count( $course_col_exists ) > 0 && count( $lesson_col_exists ) > 0 && count( $ufilter_col_exists ) > 0 ) {
			$flag = false;
		}

		return $flag;
	}


	/**
	 * Display admin notifications so user can upgrade the database table.
	 */
	public function lcms_update_table_script() {
		if( self::lcms_incomplete_db() ) {
			$class = 'notice error';
			$message = __( 'Please click <a id="lcms_upgrade_database" href="javascript:;" >here</a> to upgrade the LearnDash Course Planner Pro database.&nbsp;&nbsp;&nbsp;<span id="lcms_upgrade_database_preloader" style="display:none;"><img src="'.CS_LD_PLUGIN_URL.'/assets/spinner.gif" /></span>', 'cs_ld_addon' );
			printf( '<div id="message" class="%s lcms_upgrade_notification"> <p>%s</p></div>', $class, $message );
		}
	}
	

	/**
	 * Run upgrade script to add new column.
	 */
	public function cron_lcms_upgrade_db_script() {
		global $wpdb;
		if( self::lcms_incomplete_db() ) {

			$table_name = $wpdb->prefix . 'csld_events';

			$is_end_date_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='is_end_date' and TABLE_NAME='".$table_name."'");
			
			if( !empty($is_end_date_col_exists) ) {
				$sql = "ALTER TABLE ".$table_name." CHANGE `is_end_date` `is_end_date` VARCHAR(20) NULL DEFAULT '';";
				$wpdb->query($sql);

				$sql = "update ".$table_name." set is_end_date = 'one_day_end_date' where is_end_date = 'No';";
				$wpdb->query($sql);

				$sql = "update ".$table_name." set is_end_date = 'end_date' where is_end_date = 'Yes';";
				$wpdb->query($sql);
			}
			
			$course_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='object_parent_course' and TABLE_NAME='".$table_name."'");
			if( empty($course_col_exists) ) {
				$sql = "ALTER TABLE ".$table_name." ADD COLUMN `object_parent_course` int(10) DEFAULT '0' after `object_type`;";
				$wpdb->query($sql);
			}
			
			$lesson_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='object_parent_lesson' and TABLE_NAME='".$table_name."'");
			if( empty($lesson_col_exists) ) {
				$sql = "ALTER TABLE ".$table_name." ADD COLUMN `object_parent_lesson` int(10) DEFAULT '0' after `object_type`;";
				$wpdb->query($sql);
			}

			$lesson_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='user_filter_type' and TABLE_NAME='".$table_name."'");
			if( empty($lesson_col_exists) ) {
				$sql = "ALTER TABLE ".$table_name." ADD COLUMN `user_filter_type` ENUM('Include', 'Exclude') NULL DEFAULT 'Include';";
				$wpdb->query($sql);
			}

			$is_subsdate_as_startdate_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='is_subsdate_as_startdate' and TABLE_NAME='".$table_name."'");
			if( empty($is_subsdate_as_startdate_col_exists) ) {
				$sql = "ALTER TABLE ".$table_name." ADD COLUMN `is_subsdate_as_startdate` varchar(3) NULL DEFAULT 'No';";
				$wpdb->query($sql);
			}

			$duration_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='duration' and TABLE_NAME='".$table_name."'");
			if( empty($duration_col_exists) ) {
				$sql = "ALTER TABLE ".$table_name." ADD COLUMN `duration` INT(10) NULL DEFAULT '0';";
				$wpdb->query($sql);
			}

			$duration_type_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='duration_type' and TABLE_NAME='".$table_name."'");
			if( empty($duration_type_col_exists) ) {
				$sql = "ALTER TABLE ".$table_name." ADD COLUMN `duration_type` ENUM('Day','Month','Year') NULL DEFAULT 'Day';";
				$wpdb->query($sql);
			}
			
			$posted_by_col_exists = $wpdb->get_results("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE column_name='posted_by' and TABLE_NAME='".$table_name."'");
			if( empty( $posted_by_col_exists ) ) {
				$sql = "ALTER TABLE ".$table_name." ADD COLUMN `posted_by` INT(10) NULL DEFAULT '0';";
				$wpdb->query($sql);
			}
			
			/**
			 * check if column 'duration_end_date' not exist in the 'db_prefix_csld_events' table
			 */
			$duration_end_date_column_exists = $wpdb->get_results( "SELECT COLUMN_NAME AS columns FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='".$wpdb->dbname."' AND TABLE_NAME='".$table_name."' column_name='duration_end_date' " );
            if ( empty($duration_end_date_column_exists) ) {
				$sql    = "ALTER TABLE ".$table_name." ADD COLUMN `duration_end_date` INT(10) NULL DEFAULT '0' AFTER `end`";
				$wpdb->query( $sql );
			}

			/**
			 * check if column 'duration_end_date' not exist in the 'duration_type_end_date' table
			 */
			$duration_type_end_date_column_exists = $wpdb->get_results( "SELECT COLUMN_NAME AS columns FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='".$wpdb->dbname."' AND TABLE_NAME='".$table_name."' column_name='duration_type_end_date' " );
            if ( empty($duration_type_end_date_column_exists) ) {
				$sql    = "ALTER TABLE ".$table_name." ADD COLUMN `duration_type_end_date` ENUM('Day','Month','Year') NULL DEFAULT 'Day'";
				$wpdb->query( $sql );
			}


		}
		
	}

	/**
	 * Schedule a cron to upgrade db script.
	 */
	public function lcms_sql_upgrade() {
		
		echo $action = ( isset( $_POST['action'] ) ? $_POST['action'] : '' );
		if( $action !== 'lcms_upgrade_db_script' ) {
			exit;
		}
		echo '======';
		if ( ! wp_next_scheduled ( 'lcms_cron_upgrade_db' ) ) {
			wp_schedule_single_event( time(), 'lcms_cron_upgrade_db' );
		}

		wp_die();
		
	}
}

/**
 * @return LCMS_Main|bool
 */
function LCMS_Main() {

	$instance = LCMS_Main::instance();

	if ( ! class_exists( 'SFWD_LMS' ) ) {
		return false;
	}

	$GLOBALS['lcms_main'] = $instance;

}

add_action( 'plugins_loaded', 'LCMS_Main' );

//
function ldcms_load_translations() {
    //global $l10n;
	load_plugin_textdomain( 'cs_ld_addon', FALSE, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'ldcms_load_translations' );